/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.semaphore.impl;

import java.util.concurrent.Semaphore;
import org.noear.solon.cloud.model.BreakerEntrySim;
import org.noear.solon.cloud.model.BreakerException;

public class CloudBreakerEntryImpl
extends BreakerEntrySim {
    String breakerName;
    int thresholdValue;
    Semaphore limiter;

    public CloudBreakerEntryImpl(String breakerName, int permits) {
        this.breakerName = breakerName;
        this.thresholdValue = permits;
        this.limiter = new Semaphore(permits);
    }

    public AutoCloseable enter() throws BreakerException {
        if (this.limiter.tryAcquire()) {
            return this;
        }
        throw new BreakerException();
    }

    public void close() throws Exception {
        this.limiter.release();
    }

    public void reset(int value) {
        if (this.thresholdValue != value) {
            this.thresholdValue = value;
            this.limiter = new Semaphore(value);
        }
    }
}

