/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.sentinel.impl;

import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import java.util.ArrayList;
import org.noear.solon.cloud.model.BreakerEntrySim;
import org.noear.solon.cloud.model.BreakerException;

public class CloudBreakerEntryImpl
extends BreakerEntrySim {
    String breakerName;
    int thresholdValue;

    public CloudBreakerEntryImpl(String breakerName, int permits) {
        this.breakerName = breakerName;
        this.thresholdValue = permits;
        this.loadRules();
    }

    private void loadRules() {
        ArrayList<FlowRule> ruleList = new ArrayList<FlowRule>();
        FlowRule rule = null;
        rule = new FlowRule();
        rule.setResource(this.breakerName);
        rule.setGrade(1);
        rule.setCount((double)this.thresholdValue);
        ruleList.add(rule);
        rule = new FlowRule();
        rule.setResource(this.breakerName);
        rule.setGrade(0);
        rule.setCount((double)this.thresholdValue);
        ruleList.add(rule);
        FlowRuleManager.loadRules(ruleList);
    }

    public AutoCloseable enter() throws BreakerException {
        try {
            return SphU.entry((String)this.breakerName);
        }
        catch (BlockException ex) {
            throw new BreakerException((Throwable)ex);
        }
    }

    public void reset(int value) {
        if (this.thresholdValue != value) {
            this.thresholdValue = value;
            this.loadRules();
        }
    }
}

