/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.shiro.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.authz.aop.UserAnnotationHandler;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.shiro.aop.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserInterceptor
extends AbstractInterceptor<RequiresUser> {
    private static final Logger log = LoggerFactory.getLogger(UserInterceptor.class);
    public static final UserInterceptor instance = new UserInterceptor();
    private final UserAnnotationHandler handler = new UserAnnotationHandler();

    @Override
    public Class<RequiresUser> type() {
        return RequiresUser.class;
    }

    @Override
    public Result validate(RequiresUser annotation) {
        try {
            this.handler.assertAuthorized((Annotation)annotation);
        }
        catch (AuthorizationException e) {
            log.warn(e.getMessage());
            return Result.failure((int)403, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.failure((String)e.getMessage());
        }
        return Result.succeed();
    }
}

