/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.shiro.config;

import java.util.ArrayList;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.config.Ini;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.util.ResourceUtil;

@Configuration
public class ShiroConfiguration {
    @Inject
    AuthorizingRealm authRealm;

    @Init
    public void init() {
        ArrayList<Object> realmList = new ArrayList<Object>();
        Realm iniRealm = this.iniRealmFromLocation();
        if (iniRealm != null) {
            realmList.add(iniRealm);
        }
        if (this.authRealm != null) {
            realmList.add(this.authRealm);
        }
        SecurityUtils.setSecurityManager((SecurityManager)new DefaultSecurityManager(realmList));
    }

    protected Realm iniRealmFromLocation() {
        if (ResourceUtil.getResource((String)"shiro.ini") == null) {
            return null;
        }
        String iniLocation = "classpath:shiro.ini";
        Ini ini = Ini.fromResourcePath((String)iniLocation);
        return new IniRealm(ini);
    }
}

