/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.shiro.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.aop.AuthenticatedAnnotationHandler;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.shiro.aop.AbstractInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticateInterceptor
extends AbstractInterceptor<RequiresAuthentication> {
    private static final Logger log = LoggerFactory.getLogger(AuthenticateInterceptor.class);
    public static final AuthenticateInterceptor instance = new AuthenticateInterceptor();
    private final AuthenticatedAnnotationHandler handler = new AuthenticatedAnnotationHandler();

    @Override
    public Class<RequiresAuthentication> type() {
        return RequiresAuthentication.class;
    }

    @Override
    public Result validate(RequiresAuthentication annotation) {
        try {
            this.handler.assertAuthorized((Annotation)annotation);
        }
        catch (UnauthenticatedException e) {
            log.warn(e.getMessage());
            return Result.failure((int)401, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return Result.failure((String)e.getMessage());
        }
        return Result.succeed();
    }
}

