/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.solon;

import java.util.concurrent.Executor;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.config.SmsBanner;
import org.dromara.sms4j.comm.config.SmsConfig;
import org.dromara.sms4j.comm.config.SmsSqlConfig;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.enumerate.ConfigType;
import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.dromara.sms4j.solon.SupplierConfigFileBuilder;
import org.dromara.sms4j.solon.SupplierSqlBuilder;
import org.dromara.sms4j.solon.integration.RestrictedAround;
import org.noear.redisx.RedisClient;
import org.noear.redisx.plus.RedisBucket;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.util.LogUtil;

public class XPluginImp
implements Plugin {
    public void start(AopContext context) throws Throwable {
        Props props = context.cfg();
        SmsSqlConfig smsSqlConfig = BeanFactory.getSmsSqlConfig();
        SmsConfig smsConfig = BeanFactory.getSmsConfig();
        SmsUtil.copyBean((Object)props.getBean("sms.sql", SmsSqlConfig.class), (Object)smsSqlConfig);
        SmsUtil.copyBean((Object)props.getBean("sms", SmsConfig.class), (Object)smsConfig);
        context.wrapAndPut(SmsSqlConfig.class, (Object)smsSqlConfig);
        context.wrapAndPut(SmsConfig.class, (Object)smsConfig);
        context.wrapAndPut(DelayedTime.class, (Object)BeanFactory.getDelayedTime());
        Executor taskExecutor = BeanFactory.setExecutor((SmsConfig)smsConfig);
        BeanWrap bw = context.wrap(Executor.class, (Object)taskExecutor);
        context.putWrap("smsExecutor", bw);
        String configType = props.getProperty("sms.config-type", ConfigType.CONFIG_FILE.getName());
        if (configType.equals(ConfigType.CONFIG_FILE.getName()) || configType.equals("config-file") || configType.equals("config_file")) {
            SupplierConfigFileBuilder sf = new SupplierConfigFileBuilder(props);
            sf.init(smsConfig);
        } else if (configType.equals(ConfigType.SQL_CONFIG.getName()) || configType.equals("sql-config") || configType.equals("sql_config")) {
            SupplierSqlBuilder ss = new SupplierSqlBuilder(props);
            ss.init(smsSqlConfig);
        }
        boolean useRedis = smsConfig.getRedisCache();
        boolean aopRestricted = smsConfig.getRestricted();
        if (useRedis) {
            LogUtil.global().debug("The redis cache is enabled for sms-aggregation");
        }
        if (smsConfig.getIsPrint().booleanValue()) {
            SmsBanner.PrintBanner((String)"V 1.0.5");
        }
        Solon.app().onEvent(AppLoadEndEvent.class, e -> {
            if (aopRestricted) {
                LogUtil.global().debug("SMS restriction is enabled");
                if (useRedis) {
                    e.context().subBeansOfType(RedisClient.class, rc -> {
                        RestrictedAround ra = new RestrictedAround(smsConfig, rc.getBucket());
                        e.context().beanAroundAdd(Restricted.class, (Interceptor)ra);
                    });
                } else {
                    RedisBucket rb = null;
                    RestrictedAround ra = new RestrictedAround(smsConfig, rb);
                    e.context().beanAroundAdd(Restricted.class, (Interceptor)ra);
                }
            }
        });
    }
}

