/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.solon.integration;

import java.util.ArrayList;
import org.dromara.sms4j.comm.annotation.Restricted;
import org.dromara.sms4j.comm.config.SmsConfig;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtil;
import org.dromara.sms4j.comm.utils.TimeExpiredPoolCache;
import org.noear.redisx.plus.RedisBucket;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictedAround
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RestrictedAround.class);
    private static final int minTimer = 60000;
    private static final int accTimer = 86400000;
    private static final String REDIS_KEY = "sms:restricted:";
    private final SmsConfig config;
    private final RedisBucket redisBucket;

    public RestrictedAround(SmsConfig config, RedisBucket redisBucket) {
        this.config = config;
        this.redisBucket = redisBucket;
    }

    public Object doIntercept(Invocation inv) throws Throwable {
        Restricted anno = (Restricted)inv.method().getAnnotation(Restricted.class);
        if (anno == null) {
            return inv.invoke();
        }
        String args = "";
        ArrayList<String> argsList = new ArrayList<String>();
        try {
            args = (String)inv.args()[0];
        }
        catch (Exception e) {
            log.error("sms4j aspect get args error", (Throwable)e);
            for (Object o : (ArrayList)inv.args()[0]) {
                argsList.add((String)o);
            }
        }
        SmsBlendException process = this.redisProcess(args);
        if (process != null) {
            throw process;
        }
        argsList.forEach(f -> {
            SmsBlendException proce = null;
            try {
                proce = this.redisProcess((String)f);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new RuntimeException(e);
            }
            if (proce != null) {
                throw proce;
            }
        });
        return inv.invoke();
    }

    /*
     * Enabled aggressive block sorting
     */
    private SmsBlendException process(String args) throws Exception {
        TimeExpiredPoolCache instance = TimeExpiredPoolCache.getInstance();
        Integer accountMax = this.config.getAccountMax();
        Integer minuteMax = this.config.getMinuteMax();
        if (SmsUtil.isNotEmpty((Object)accountMax)) {
            Integer i = (Integer)instance.get(args + "max");
            if (SmsUtil.isEmpty((Object)i)) {
                instance.put(args + "max", (Object)1, 86400000L);
            } else {
                if (i > accountMax) {
                    log.info("The phone:" + args + ",number of short messages reached the maximum today");
                    return new SmsBlendException("The phone:" + args + ",number of short messages reached the maximum today");
                }
                instance.put(args + "max", (Object)(i + 1), 86400000L);
            }
        }
        if (!SmsUtil.isNotEmpty((Object)minuteMax)) return null;
        Integer o = (Integer)instance.get(args);
        if (!SmsUtil.isNotEmpty((Object)o)) {
            instance.put(args, (Object)1, 60000L);
            return null;
        }
        if (o < minuteMax) {
            instance.put(args, (Object)(o + 1), 60000L);
            return null;
        }
        log.info("The phone:" + args + ",number of short messages reached the maximum today");
        return new SmsBlendException("The phone:", args + " Text messages are sent too often\uff01");
    }

    /*
     * Enabled aggressive block sorting
     */
    private SmsBlendException redisProcess(String args) throws Exception {
        String rkey;
        if (this.config.getRedisCache() == false) return this.process(args);
        if (this.redisBucket == null) {
            return this.process(args);
        }
        Integer accountMax = this.config.getAccountMax();
        Integer minuteMax = this.config.getMinuteMax();
        if (SmsUtil.isNotEmpty((Object)accountMax)) {
            rkey = REDIS_KEY + args + "max";
            String amax = this.redisBucket.get(rkey);
            if (SmsUtil.isEmpty((Object)amax)) {
                this.redisBucket.store(rkey, "1", 86400);
            } else {
                Integer i = Integer.parseInt(amax);
                if (i > accountMax) {
                    log.info("The phone:" + args + ",number of short messages reached the maximum today");
                    return new SmsBlendException("The phone:" + args + ",number of short messages reached the maximum today");
                }
                this.redisBucket.store(rkey, i + 1 + "", 86400);
            }
        }
        if (!SmsUtil.isNotEmpty((Object)minuteMax)) return null;
        rkey = REDIS_KEY + args;
        String rval = this.redisBucket.get(rkey);
        if (!SmsUtil.isNotEmpty((Object)rval)) {
            this.redisBucket.store(rkey, "1", 60);
            return null;
        }
        Integer o = Integer.parseInt(rval);
        if (o < minuteMax) {
            this.redisBucket.store(rkey, o + 1 + "", 60);
            return null;
        }
        log.info("The phone:" + args + ",number of short messages reached the maximum today");
        return new SmsBlendException("The phone:", args + " Text messages are sent too often\uff01");
    }
}

