/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.snack.ONodeType;
import org.noear.snack.OValue;
import org.noear.snack.core.Constants;
import org.noear.snack.core.Feature;

public class ONodeData {
    public OValue value = null;
    public Map<String, ONode> object = null;
    public List<ONode> array = null;
    public ONodeType nodeType = ONodeType.Null;
    protected ONode _n;
    public Map<String, String> attrs = null;

    public Map<String, ONode> object() {
        this.tryInitObject(this._n._c);
        return this.object;
    }

    public List<ONode> array() {
        this.tryInitArray();
        return this.array;
    }

    public OValue value() {
        this.tryInitValue();
        return this.value;
    }

    public ONodeData(ONode n) {
        this._n = n;
    }

    protected void tryInitNull() {
        if (this.nodeType != ONodeType.Null) {
            this.nodeType = ONodeType.Null;
            if (this.object != null) {
                this.object.clear();
                this.object = null;
            }
            if (this.array != null) {
                this.array.clear();
                this.array = null;
            }
            this.value = null;
        }
    }

    protected void tryInitValue() {
        if (this.nodeType != ONodeType.Value) {
            this.nodeType = ONodeType.Value;
            if (this.value == null) {
                this.value = new OValue(this._n);
            }
        }
    }

    protected void tryInitObject(Constants cfg) {
        if (this.nodeType != ONodeType.Object) {
            this.nodeType = ONodeType.Object;
            if (this.object == null) {
                this.object = cfg.hasFeature(Feature.OrderedField) ? new LinkedHashMap<String, ONode>() : new HashMap<String, ONode>();
            }
        }
    }

    protected void tryInitArray() {
        if (this.nodeType != ONodeType.Array) {
            this.nodeType = ONodeType.Array;
            if (this.array == null) {
                this.array = new ArrayList<ONode>();
            }
        }
    }

    protected void shiftToArray() {
        this.tryInitArray();
        if (this.object != null) {
            for (ONode n1 : this.object.values()) {
                this.array.add(n1);
            }
            this.object.clear();
            this.object = null;
        }
    }

    public String attrGet(String key) {
        if (this.attrs != null) {
            return this.attrs.get(key);
        }
        return null;
    }

    public void attrSet(String key, String val) {
        if (this.attrs == null) {
            this.attrs = new LinkedHashMap<String, String>();
        }
        this.attrs.put(key, val);
    }
}

