/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.noear.snack.ONode;
import org.noear.snack.OValueType;

public class OValue {
    protected long _integer;
    protected double _decimal;
    protected String _string;
    protected boolean _bool;
    protected Date _date;
    protected Number _bignumber;
    protected ONode _n;
    private OValueType _type = OValueType.Null;

    public OValue(ONode n) {
        this._n = n;
    }

    public OValueType type() {
        return this._type;
    }

    public void set(Object val) {
        if (val == null) {
            this._type = OValueType.Null;
            return;
        }
        if (val instanceof String) {
            this.setString((String)val);
            return;
        }
        if (val instanceof Date) {
            this.setDate((Date)val);
            return;
        }
        if (val instanceof Integer) {
            this.setInteger(((Integer)val).intValue());
            return;
        }
        if (val instanceof Long) {
            this.setInteger((Long)val);
            return;
        }
        if (val instanceof Double) {
            this.setDecimal((Double)val);
            return;
        }
        if (val instanceof Float) {
            this.setDecimal(((Float)val).floatValue());
            return;
        }
        if (val instanceof Boolean) {
            this.setBool((Boolean)val);
            return;
        }
        if (val instanceof BigInteger) {
            this.setBignumber((BigInteger)val);
            return;
        }
        if (val instanceof BigDecimal) {
            this.setBignumber((BigDecimal)val);
            return;
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7c7b\u578b:" + val.getClass().getName());
    }

    public void setNull() {
        this._type = OValueType.Null;
    }

    public void setInteger(long val) {
        this._type = OValueType.Integer;
        this._integer = val;
    }

    public void setDecimal(double val) {
        this._type = OValueType.Decimal;
        this._decimal = val;
    }

    public void setBignumber(Number val) {
        this._type = OValueType.Bignumber;
        this._bignumber = val;
    }

    public void setString(String val) {
        this._type = OValueType.String;
        this._string = val;
    }

    public void setBool(boolean val) {
        this._type = OValueType.Boolean;
        this._bool = val;
    }

    public void setDate(Date val) {
        this._type = OValueType.DateTime;
        this._date = val;
    }

    public Object getRaw() {
        switch (this._type) {
            case String: {
                return this._string;
            }
            case Integer: {
                return this._integer;
            }
            case DateTime: {
                return this._date;
            }
            case Boolean: {
                return this._bool;
            }
            case Decimal: {
                return this._decimal;
            }
            case Bignumber: {
                return this._bignumber;
            }
        }
        return null;
    }

    public long getRawInteger() {
        return this._integer;
    }

    public double getRawDecimal() {
        return this._decimal;
    }

    public String getRawString() {
        return this._string;
    }

    public boolean getRawBoolean() {
        return this._bool;
    }

    public Date getRawDate() {
        return this._date;
    }

    public Number getRawBignumber() {
        return this._bignumber;
    }

    public boolean isNull() {
        return this._type == OValueType.Null;
    }

    public char getChar() {
        switch (this._type) {
            case Integer: {
                return (char)this._integer;
            }
            case Decimal: {
                return (char)this._decimal;
            }
            case Bignumber: {
                return (char)this._bignumber.longValue();
            }
            case String: {
                if (this._string == null || this._string.length() == 0) {
                    return '\u0000';
                }
                return this._string.charAt(0);
            }
            case Boolean: {
                return this._bool ? (char)'1' : '0';
            }
            case DateTime: {
                return '\u0000';
            }
        }
        return '\u0000';
    }

    public short getShort() {
        return (short)this.getLong();
    }

    public int getInt() {
        return (int)this.getLong();
    }

    public long getLong() {
        switch (this._type) {
            case Integer: {
                return this._integer;
            }
            case Decimal: {
                return (long)this._decimal;
            }
            case Bignumber: {
                return this._bignumber.longValue();
            }
            case String: {
                if (this._string == null || this._string.length() == 0) {
                    return 0L;
                }
                return Long.parseLong(this._string);
            }
            case Boolean: {
                return this._bool ? 1L : 0L;
            }
            case DateTime: {
                return this._date.getTime();
            }
        }
        return 0L;
    }

    public float getFloat() {
        return (float)this.getDouble();
    }

    public double getDouble() {
        switch (this._type) {
            case Decimal: {
                return this._decimal;
            }
            case Integer: {
                return this._integer;
            }
            case Bignumber: {
                return this._bignumber.doubleValue();
            }
            case String: {
                if (this._string == null || this._string.length() == 0) {
                    return 0.0;
                }
                return Double.parseDouble(this._string);
            }
            case Boolean: {
                return this._bool ? 1.0 : 0.0;
            }
            case DateTime: {
                return this._date.getTime();
            }
        }
        return 0.0;
    }

    public String getString() {
        switch (this._type) {
            case String: {
                return this._string;
            }
            case Integer: {
                return String.valueOf(this._integer);
            }
            case Decimal: {
                return String.valueOf(this._decimal);
            }
            case Bignumber: {
                return String.valueOf(this._bignumber);
            }
            case Boolean: {
                return String.valueOf(this._bool);
            }
            case DateTime: {
                return String.valueOf(this._date);
            }
        }
        return this._n._c.null_string;
    }

    public boolean getBoolean() {
        switch (this._type) {
            case Boolean: {
                return this._bool;
            }
            case Integer: {
                return this._integer > 0L;
            }
            case Decimal: {
                return this._decimal > 0.0;
            }
            case Bignumber: {
                return this._bignumber.longValue() > 0L;
            }
            case String: {
                return false;
            }
            case DateTime: {
                return false;
            }
        }
        return false;
    }

    public Date getDate() {
        switch (this._type) {
            case DateTime: {
                return this._date;
            }
            case String: {
                return OValue.parseDate(this._string);
            }
            case Integer: {
                return new Date(this._integer);
            }
        }
        return null;
    }

    private static Date parseDate(String dateString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return sdf.parse(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }
}

