/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.from;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.noear.snack.ONode;
import org.noear.snack.OValue;
import org.noear.snack.core.Context;
import org.noear.snack.core.exts.CharBuffer;
import org.noear.snack.core.exts.CharReader;
import org.noear.snack.core.exts.ThData;
import org.noear.snack.core.utils.IOUtil;
import org.noear.snack.from.Fromer;

public class JsonFromer
implements Fromer {
    private static final ThData<CharBuffer> tlBuilder = new ThData<CharBuffer>(() -> new CharBuffer());

    @Override
    public void handle(Context ctx) throws IOException {
        int len = ctx.text.length();
        if (len == 0) {
            ctx.node = new ONode(ctx.config);
        } else {
            char prefix = ctx.text.charAt(0);
            char suffix = ctx.text.charAt(ctx.text.length() - 1);
            if (prefix == '{' && suffix == '}' || prefix == '[' && suffix == ']') {
                CharBuffer sBuf = (CharBuffer)tlBuilder.get();
                sBuf.setLength(0);
                ctx.node = new ONode(ctx.config);
                this.analyse(new CharReader(ctx.text), sBuf, ctx.node);
            } else if (len >= 2 && (prefix == '\"' && suffix == '\"' || prefix == '\'' && suffix == '\'')) {
                ctx.node = this.analyse_val(ctx.text.substring(1, len - 1), true, false);
            } else if (prefix != '<' && len < 40) {
                ctx.node = this.analyse_val(ctx.text, false, true);
            } else {
                ctx.node = new ONode(ctx.config);
                ctx.node.val().setString(ctx.text);
            }
        }
    }

    public void analyse(CharReader sr, CharBuffer sBuf, ONode p) throws IOException {
        String name = null;
        block10: while (sr.read()) {
            char c = sr.value();
            switch (c) {
                case '\"': {
                    this.scanString(sr, sBuf, '\"');
                    if (!this.analyse_buf(p, name, sBuf)) continue block10;
                    name = null;
                    continue block10;
                }
                case '\'': {
                    this.scanString(sr, sBuf, '\'');
                    if (!this.analyse_buf(p, name, sBuf)) continue block10;
                    name = null;
                    continue block10;
                }
                case '{': {
                    if (p.isObject()) {
                        this.analyse(sr, sBuf, p.getNew(name).asObject());
                        name = null;
                        continue block10;
                    }
                    if (p.isArray()) {
                        this.analyse(sr, sBuf, p.addNew().asObject());
                        continue block10;
                    }
                    this.analyse(sr, sBuf, p.asObject());
                    continue block10;
                }
                case '[': {
                    if (p.isObject()) {
                        this.analyse(sr, sBuf, p.getNew(name).asArray());
                        name = null;
                        continue block10;
                    }
                    if (p.isArray()) {
                        this.analyse(sr, sBuf, p.addNew().asArray());
                        continue block10;
                    }
                    this.analyse(sr, sBuf, p.asArray());
                    continue block10;
                }
                case ':': {
                    name = sBuf.toString();
                    sBuf.setLength(0);
                    continue block10;
                }
                case ',': {
                    if (sBuf.length() <= 0 || !this.analyse_buf(p, name, sBuf)) continue block10;
                    name = null;
                    continue block10;
                }
                case '}': {
                    if (sBuf.length() > 0) {
                        this.analyse_buf(p, name, sBuf);
                    }
                    return;
                }
                case ']': {
                    if (sBuf.length() > 0) {
                        this.analyse_buf(p, name, sBuf);
                    }
                    return;
                }
            }
            if (sBuf.length() == 0) {
                if (c <= ' ') continue;
                sBuf.append(c);
                continue;
            }
            sBuf.append(c);
        }
    }

    private boolean analyse_buf(ONode p, String name, CharBuffer sBuf) {
        if (p.isObject()) {
            if (name != null) {
                p.setNode(name, this.analyse_val(sBuf));
                sBuf.setLength(0);
                return true;
            }
        } else if (p.isArray()) {
            p.addNode(this.analyse_val(sBuf));
            sBuf.setLength(0);
        }
        return false;
    }

    private void scanString(CharReader sr, CharBuffer sBuf, char quote) throws IOException {
        sBuf.isString = true;
        while (sr.read()) {
            char c = sr.value();
            if (quote == c) {
                return;
            }
            if ('\\' == c) {
                c = sr.next();
                if ('t' == c || 'r' == c || 'n' == c || 'f' == c || 'b' == c || '\"' == c || '\'' == c || '/' == c || c >= '0' && c <= '7') {
                    sBuf.append(IOUtil.CHARS_MARK_REV[c]);
                    continue;
                }
                if ('x' == c) {
                    char x1 = sr.next();
                    char x2 = sr.next();
                    int val = IOUtil.DIGITS_MARK[x1] * 16 + IOUtil.DIGITS_MARK[x2];
                    sBuf.append((char)val);
                    continue;
                }
                if ('u' == c) {
                    int val = 0;
                    c = sr.next();
                    val = (val << 4) + IOUtil.DIGITS_MARK[c];
                    c = sr.next();
                    val = (val << 4) + IOUtil.DIGITS_MARK[c];
                    c = sr.next();
                    val = (val << 4) + IOUtil.DIGITS_MARK[c];
                    c = sr.next();
                    val = (val << 4) + IOUtil.DIGITS_MARK[c];
                    sBuf.append((char)val);
                    continue;
                }
                sBuf.append('\\');
                sBuf.append(c);
                continue;
            }
            sBuf.append(c);
        }
    }

    private ONode analyse_val(CharBuffer sBuf) {
        if (!sBuf.isString) {
            sBuf.trimLast();
        }
        return this.analyse_val(sBuf.toString(), sBuf.isString, false);
    }

    private ONode analyse_val(String sval, boolean isString, boolean isNoterr) {
        ONode orst = new ONode();
        OValue oval = orst.val();
        if (isString) {
            oval.setString(sval);
        } else {
            char c = sval.charAt(0);
            int len = sval.length();
            if (c == 't' && len == 4) {
                oval.setBool(true);
            } else if (c == 'f' && len == 5) {
                oval.setBool(false);
            } else if (c == 'n') {
                if (len == 4) {
                    oval.setNull();
                } else if (sval.indexOf(68) == 4) {
                    long ticks = Long.parseLong(sval.substring(9, sval.length() - 1));
                    oval.setDate(new Date(ticks));
                }
            } else if (c == 'N' && len == 3) {
                oval.setNull();
            } else if (c == 'u' && len == 9) {
                oval.setNull();
            } else if (c >= '0' && c <= '9' || c == '-') {
                if (sval.length() > 16) {
                    if (sval.indexOf(46) > 0) {
                        oval.setBignumber(new BigDecimal(sval));
                    } else {
                        oval.setBignumber(new BigInteger(sval));
                    }
                } else if (sval.indexOf(46) > 0) {
                    oval.setDecimal(Double.parseDouble(sval));
                } else {
                    oval.setInteger(Long.parseLong(sval));
                }
            } else if (isNoterr) {
                oval.setString(sval);
            } else {
                throw new RuntimeException("Format error!");
            }
        }
        return orst;
    }
}

