/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.from;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import org.noear.snack.ONode;
import org.noear.snack.core.Constants;
import org.noear.snack.core.Context;
import org.noear.snack.core.Feature;
import org.noear.snack.core.exts.FieldWrap;
import org.noear.snack.core.utils.BeanUtil;
import org.noear.snack.from.Fromer;

public class ObjectFromer
implements Fromer {
    @Override
    public void handle(Context ctx) {
        ctx.node = this.analyse(ctx.config, ctx.object);
    }

    private ONode analyse(Constants cfg, Object source) {
        if (source == null) {
            return new ONode();
        }
        Class<?> clz = source.getClass();
        ONode rst = new ONode(cfg);
        if (source instanceof ONode) {
            rst.val(source);
        } else if (source instanceof String) {
            rst.val().setString((String)source);
        } else if (source instanceof Date) {
            rst.val().setDate((Date)source);
        } else if (source instanceof Integer) {
            rst.val().setInteger(((Integer)source).intValue());
        } else if (source instanceof Long) {
            rst.val().setInteger((Long)source);
        } else if (source instanceof Float) {
            rst.val().setDecimal(((Float)source).floatValue());
        } else if (source instanceof Double) {
            rst.val().setDecimal((Double)source);
        } else if (source instanceof Short) {
            rst.val().setInteger(((Short)source).shortValue());
        } else if (source instanceof Character) {
            rst.val().setInteger(((Character)source).charValue());
        } else if (source instanceof Byte) {
            rst.val().setInteger(((Byte)source).byteValue());
        } else if (source instanceof Boolean) {
            rst.val().setBool((Boolean)source);
        } else if (source instanceof Number) {
            rst.val().setBignumber((Number)source);
        } else if (source instanceof Throwable) {
            this.analyseBean(cfg, rst, clz, source);
        } else if (!this.analyseArray(cfg, rst, clz, source)) {
            if (clz.isEnum()) {
                Enum em = (Enum)source;
                if (cfg.hasFeature(Feature.EnumUsingName)) {
                    rst.val().setString(em.name());
                } else {
                    rst.val().setInteger(em.ordinal());
                }
            } else if (source instanceof Map) {
                if (cfg.hasFeature(Feature.WriteClassName)) {
                    this.typeSet(cfg, rst, clz);
                }
                rst.asObject();
                Map map = (Map)source;
                for (Object k : map.keySet()) {
                    if (k == null) continue;
                    rst.setNode(k.toString(), this.analyse(cfg, map.get(k)));
                }
            } else if (source instanceof Iterable) {
                rst.asArray();
                ONode ary = rst;
                if (cfg.hasFeature(Feature.WriteClassName)) {
                    rst.add(this.typeSet(cfg, new ONode(cfg), clz));
                    ary = rst.addNew().asArray();
                }
                for (Object o : (Iterable)source) {
                    ary.addNode(this.analyse(cfg, o));
                }
            } else if (source instanceof Enumeration) {
                rst.asArray();
                Enumeration o = (Enumeration)source;
                while (o.hasMoreElements()) {
                    rst.addNode(this.analyse(cfg, o.nextElement()));
                }
            } else {
                String clzName = clz.getName();
                if (clzName.endsWith(".Undefined")) {
                    rst.val().setNull();
                } else if (!this.analyseOther(cfg, rst, clz, source) && !clzName.startsWith("jdk.")) {
                    this.analyseBean(cfg, rst, clz, source);
                }
            }
        }
        return rst;
    }

    private ONode typeSet(Constants cfg, ONode o, Class<?> clz) {
        return o.set(cfg.type_key, clz.getName());
    }

    private boolean analyseArray(Constants cfg, ONode rst, Class<?> clz, Object obj) {
        if (obj instanceof Object[]) {
            rst.asArray();
            for (Object o : (Object[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof byte[]) {
            rst.asArray();
            for (byte o : (byte[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof short[]) {
            rst.asArray();
            for (short o : (short[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof int[]) {
            rst.asArray();
            for (int o : (int[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof long[]) {
            rst.asArray();
            for (long o : (long[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof float[]) {
            rst.asArray();
            for (float o : (float[])obj) {
                rst.addNode(this.analyse(cfg, Float.valueOf(o)));
            }
        } else if (obj instanceof double[]) {
            rst.asArray();
            for (double o : (double[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof boolean[]) {
            rst.asArray();
            for (boolean o : (boolean[])obj) {
                rst.addNode(this.analyse(cfg, o));
            }
        } else if (obj instanceof char[]) {
            rst.asArray();
            for (char o : (char[])obj) {
                rst.addNode(this.analyse(cfg, Character.valueOf(o)));
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean analyseBean(Constants cfg, ONode rst, Class<?> clz, Object obj) {
        rst.asObject();
        if (cfg.hasFeature(Feature.WriteClassName)) {
            rst.set(cfg.type_key, clz.getName());
        }
        Collection<FieldWrap> list = BeanUtil.getAllFields(clz);
        for (FieldWrap f : list) {
            Object val = f.get(obj);
            if (val == null || val.equals(obj)) continue;
            rst.setNode(f.name(), this.analyse(cfg, val));
        }
        return true;
    }

    private boolean analyseOther(Constants cfg, ONode rst, Class<?> clz, Object obj) {
        if (obj instanceof SimpleDateFormat) {
            rst.set(cfg.type_key, clz.getName());
            rst.set("val", ((SimpleDateFormat)obj).toPattern());
        } else if (clz == Class.class) {
            rst.val().setString(clz.getName());
        } else if (obj instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)obj;
            InetAddress inetAddress = address.getAddress();
            rst.set("address", inetAddress.getHostAddress());
            rst.set("port", address.getPort());
        } else if (obj instanceof File) {
            rst.val().setString(((File)obj).getPath());
        } else if (obj instanceof InetAddress) {
            rst.val().setString(((InetAddress)obj).getHostAddress());
        } else if (obj instanceof TimeZone) {
            rst.val().setString(((TimeZone)obj).getID());
        } else if (obj instanceof Currency) {
            rst.val().setString(((Currency)obj).getCurrencyCode());
        } else if (obj instanceof Iterator) {
            rst.asArray();
            ((Iterator)obj).forEachRemaining(v -> rst.add(this.analyse(cfg, v)));
        } else if (obj instanceof Map.Entry) {
            Map.Entry kv = (Map.Entry)obj;
            Object k = kv.getKey();
            Object v2 = kv.getValue();
            rst.asObject();
            if (k != null) {
                rst.set(k.toString(), this.analyse(cfg, v2));
            }
        } else if (obj instanceof Calendar) {
            rst.val().setDate(((Calendar)obj).getTime());
        } else if (obj instanceof Clob) {
            rst.val().setString(BeanUtil.clobToString((Clob)obj));
        } else if (obj instanceof Appendable) {
            rst.val().setString(obj.toString());
        } else {
            return false;
        }
        return true;
    }
}

