/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.to;

import java.util.ArrayList;
import java.util.HashMap;
import org.noear.snack.ONode;
import org.noear.snack.OValue;
import org.noear.snack.core.Context;
import org.noear.snack.to.Toer;

public class DataToer
implements Toer {
    @Override
    public void handle(Context ctx) {
        ctx.object = this.analyse(ctx.node);
    }

    private Object analyse(ONode o) {
        if (o == null) {
            return null;
        }
        switch (o.nodeType()) {
            case Value: {
                OValue d = o.nodeData().value;
                switch (d.type()) {
                    case Integer: {
                        return d.getRawInteger();
                    }
                    case Decimal: {
                        return d.getRawDecimal();
                    }
                    case Boolean: {
                        return d.getRawBoolean();
                    }
                    case DateTime: {
                        return d.getRawDate();
                    }
                    case Bignumber: {
                        return d.getRawBignumber();
                    }
                    case Null: {
                        return null;
                    }
                }
                return d.getString();
            }
            case Object: {
                HashMap map = new HashMap();
                o.forEach((k, v) -> map.put(k, this.analyse((ONode)v)));
                return map;
            }
            case Array: {
                ArrayList ary = new ArrayList();
                o.forEach(v -> ary.add(this.analyse((ONode)v)));
                return ary;
            }
        }
        return null;
    }
}

