/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.to;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import org.noear.snack.ONode;
import org.noear.snack.ONodeData;
import org.noear.snack.OValue;
import org.noear.snack.core.Constants;
import org.noear.snack.core.Context;
import org.noear.snack.core.Feature;
import org.noear.snack.core.exts.ThData;
import org.noear.snack.core.utils.IOUtil;
import org.noear.snack.core.utils.TypeUtil;
import org.noear.snack.to.Toer;

public class JsonToer
implements Toer {
    private static final ThData<StringBuilder> tlBuilder = new ThData<Object>(() -> new StringBuilder(5120));

    @Override
    public void handle(Context context) {
        ONode o = context.node;
        if (null != o) {
            StringBuilder sb = (StringBuilder)tlBuilder.get();
            sb.setLength(0);
            this.analyse(context.config, o, sb);
            context.text = sb.toString();
        }
    }

    public void analyse(Constants cfg, ONode o, StringBuilder sb) {
        if (o == null) {
            return;
        }
        switch (o.nodeType()) {
            case Value: {
                this.writeValue(cfg, sb, o.nodeData());
                break;
            }
            case Array: {
                this.writeArray(cfg, sb, o.nodeData());
                break;
            }
            case Object: {
                this.writeObject(cfg, sb, o.nodeData());
                break;
            }
            default: {
                sb.append("null");
            }
        }
    }

    private void writeArray(Constants cfg, StringBuilder sBuf, ONodeData d) {
        sBuf.append("[");
        Iterator<ONode> iterator = d.array.iterator();
        while (iterator.hasNext()) {
            ONode sub = iterator.next();
            this.analyse(cfg, sub, sBuf);
            if (!iterator.hasNext()) continue;
            sBuf.append(",");
        }
        sBuf.append("]");
    }

    private void writeObject(Constants cfg, StringBuilder sBuf, ONodeData d) {
        sBuf.append("{");
        Iterator<String> itr = d.object.keySet().iterator();
        while (itr.hasNext()) {
            String k = itr.next();
            this.writeName(cfg, sBuf, k);
            sBuf.append(":");
            this.analyse(cfg, d.object.get(k), sBuf);
            if (!itr.hasNext()) continue;
            sBuf.append(",");
        }
        sBuf.append("}");
    }

    private void writeValue(Constants cfg, StringBuilder sBuf, ONodeData d) {
        OValue v = d.value;
        switch (v.type()) {
            case Null: {
                sBuf.append("null");
                break;
            }
            case String: {
                this.writeValString(cfg, sBuf, v.getRawString(), true);
                break;
            }
            case DateTime: {
                this.writeValDate(cfg, sBuf, v.getRawDate());
                break;
            }
            case Boolean: {
                this.writeValBool(cfg, sBuf, v.getRawBoolean());
                break;
            }
            case Bignumber: {
                this.writeValBignum(cfg, sBuf, v.getRawBignumber());
                break;
            }
            case Integer: {
                sBuf.append(v.getRawInteger());
                break;
            }
            case Decimal: {
                sBuf.append(v.getRawDecimal());
                break;
            }
            default: {
                sBuf.append(v.getString());
            }
        }
    }

    private void writeName(Constants cfg, StringBuilder sBuf, String val) {
        if (cfg.hasFeature(Feature.QuoteFieldNames)) {
            sBuf.append("\"").append(val).append("\"");
        } else {
            sBuf.append(val);
        }
    }

    private void writeValDate(Constants cfg, StringBuilder sBuf, Date val) {
        if (cfg.hasFeature(Feature.WriteDateUseTicks)) {
            sBuf.append(val.getTime());
        } else if (cfg.hasFeature(Feature.WriteDateUseFormat)) {
            this.writeValString(cfg, sBuf, cfg.dateToString(val), false);
        } else {
            sBuf.append("new Date(").append(val.getTime()).append(")");
        }
    }

    private void writeValBool(Constants cfg, StringBuilder sBuf, Boolean val) {
        if (cfg.hasFeature(Feature.WriteBoolUse01)) {
            sBuf.append(val != false ? 1 : 0);
        } else {
            sBuf.append(val != false ? "true" : "false");
        }
    }

    private void writeValBignum(Constants cfg, StringBuilder sBuf, Number val) {
        String sVal = val.toString();
        if (val instanceof BigInteger) {
            BigInteger v = (BigInteger)val;
            if (sVal.length() > 16 && (v.compareTo(TypeUtil.INT_LOW) < 0 || v.compareTo(TypeUtil.INT_HIGH) > 0) && cfg.hasFeature(Feature.BrowserCompatible)) {
                this.writeValString(cfg, sBuf, sVal, false);
            } else {
                sBuf.append(sVal);
            }
            return;
        }
        if (val instanceof BigDecimal) {
            BigDecimal v = (BigDecimal)val;
            if (sVal.length() > 16 && (v.compareTo(TypeUtil.DEC_LOW) < 0 || v.compareTo(TypeUtil.DEC_HIGH) > 0) && cfg.hasFeature(Feature.BrowserCompatible)) {
                this.writeValString(cfg, sBuf, sVal, false);
            } else {
                sBuf.append(sVal);
            }
            return;
        }
        sBuf.append(sVal);
    }

    private void writeValString(Constants cfg, StringBuilder sBuf, String val, boolean isStr) {
        sBuf.append("\"");
        if (isStr) {
            boolean isCompatible = cfg.hasFeature(Feature.BrowserCompatible);
            boolean isSecure = cfg.hasFeature(Feature.BrowserSecure);
            int len = val.length();
            for (int i = 0; i < len; ++i) {
                char c = val.charAt(i);
                if (c == '\\' || c == '\"' || c == '\n' || c == '\r' || c == '\t' || c == '\f' || c == '\b' || c >= '\u0000' && c <= '\u0007') {
                    sBuf.append("\\");
                    sBuf.append(IOUtil.CHARS_MARK[c]);
                    continue;
                }
                if (isSecure && (c == '(' || c == ')' || c == '<' || c == '>')) {
                    sBuf.append('\\');
                    sBuf.append('u');
                    sBuf.append(IOUtil.DIGITS[c >>> 12 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c >>> 8 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                    sBuf.append(IOUtil.DIGITS[c & 0xF]);
                    continue;
                }
                if (isCompatible) {
                    if (c < ' ') {
                        sBuf.append('\\');
                        sBuf.append('u');
                        sBuf.append('0');
                        sBuf.append('0');
                        sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                        sBuf.append(IOUtil.DIGITS[c & 0xF]);
                        continue;
                    }
                    if (c >= '\u007f') {
                        sBuf.append('\\');
                        sBuf.append('u');
                        sBuf.append(IOUtil.DIGITS[c >>> 12 & 0xF]);
                        sBuf.append(IOUtil.DIGITS[c >>> 8 & 0xF]);
                        sBuf.append(IOUtil.DIGITS[c >>> 4 & 0xF]);
                        sBuf.append(IOUtil.DIGITS[c & 0xF]);
                        continue;
                    }
                }
                sBuf.append(c);
            }
        } else {
            sBuf.append(val);
        }
        sBuf.append("\"");
    }
}

