/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.noear.snack.ONode;
import org.noear.snack.core.Constants;
import org.noear.snack.core.Handler;
import org.noear.snack.core.TypeRef;

public class Context {
    public final Constants config;
    public Object source;
    public Object target;
    public Class<?> target_clz;
    public Type target_type;

    public Context(Constants config, Object from) {
        this.config = config;
        this.source = from;
    }

    public Context(Constants config, ONode node, Type type0) {
        this.config = config;
        this.source = node;
        if (type0 == null) {
            return;
        }
        if (type0 instanceof Class) {
            Class clz = (Class)type0;
            if (TypeRef.class.isAssignableFrom(clz)) {
                Type superClass = clz.getGenericSuperclass();
                Type type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
                this.initType(type);
                return;
            }
            if (clz.getName().indexOf("$") > 0) {
                this.initType(clz.getGenericSuperclass());
            } else {
                this.initType(clz, clz);
            }
        } else {
            this.initType(type0);
        }
    }

    private void initType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            this.initType(type, (Class)pType.getRawType());
        } else {
            this.initType(type, (Class)type);
        }
    }

    private void initType(Type type, Class<?> clz) {
        this.target_type = type;
        this.target_clz = clz;
    }

    public Context handle(Handler handler) {
        try {
            handler.handle(this);
            return this;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

