/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.exts;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.noear.snack.annotation.NodeName;
import org.noear.snack.core.utils.StringUtil;

public class FieldWrap {
    public final Field field;
    public final Class<?> type;
    public final Type genericType;
    private Method _getter;
    private Method _setter;
    private String _name;

    public FieldWrap(Class<?> clz, Field f) {
        this.field = f;
        this.type = f.getType();
        this.genericType = f.getGenericType();
        this._getter = FieldWrap.findGetter(clz, f);
        this._setter = FieldWrap.findSetter(clz, f);
        NodeName anno = f.getAnnotation(NodeName.class);
        if (anno != null) {
            this._name = anno.value();
        }
        if (StringUtil.isEmpty(this._name)) {
            this._name = this.field.getName();
        }
    }

    public String name() {
        return this._name;
    }

    public void setValue(Object tObj, Object val) {
        try {
            if (this._setter == null) {
                this.field.set(tObj, val);
            } else {
                this._setter.invoke(tObj, val);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object getValue(Object tObj) {
        try {
            if (this._getter == null) {
                return this.field.get(tObj);
            }
            return this._getter.invoke(tObj, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Method findGetter(Class<?> tCls, Field field) {
        String fieldName = field.getName();
        String firstLetter = fieldName.substring(0, 1).toUpperCase();
        String setMethodName = "get" + firstLetter + fieldName.substring(1);
        try {
            Method getFun = tCls.getMethod(setMethodName, new Class[0]);
            if (getFun != null) {
                return getFun;
            }
        }
        catch (NoSuchMethodException getFun) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static Method findSetter(Class<?> tCls, Field field) {
        String fieldName = field.getName();
        String firstLetter = fieldName.substring(0, 1).toUpperCase();
        String setMethodName = "set" + firstLetter + fieldName.substring(1);
        try {
            Method setFun = tCls.getMethod(setMethodName, field.getType());
            if (setFun != null) {
                return setFun;
            }
        }
        catch (NoSuchMethodException setFun) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

