/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.Feature;
import org.noear.snack.core.exts.Act1;

public class Constants {
    public static int features_def = Feature.of(Feature.OrderedField, Feature.WriteDateUseTicks, Feature.StringNullAsEmpty, Feature.QuoteFieldNames);
    public static int features_serialize = Feature.of(Feature.OrderedField, Feature.WriteDateUseTicks, Feature.BrowserCompatible, Feature.WriteClassName, Feature.QuoteFieldNames);
    public DateFormat date_format = DEFAULTS.DEF_DATE_FORMAT;
    public String type_key = "@type";
    public TimeZone time_zone = DEFAULTS.DEF_TIME_ZONE;
    public Locale locale = DEFAULTS.DEF_LOCALE;
    public int features = DEFAULTS.DEF_FEATURES;
    public boolean get_readonly = false;

    public static final Constants def() {
        return new Constants(features_def);
    }

    public static final Constants serialize() {
        return new Constants(features_serialize);
    }

    public static Constants of(Feature ... features) {
        return new Constants().add(features);
    }

    public Constants add(Feature ... features) {
        for (Feature f : features) {
            this.features = Feature.config(this.features, f, true);
        }
        return this;
    }

    public Constants sub(Feature ... features) {
        for (Feature f : features) {
            this.features = Feature.config(this.features, f, false);
        }
        return this;
    }

    public Constants() {
    }

    public Constants(int features) {
        this.features = features;
    }

    public Constants build(Act1<Constants> builder) {
        builder.run(this);
        return this;
    }

    public final String dateToString(Date date) {
        return this.date_format.format(date);
    }

    public final boolean hasFeature(Feature feature) {
        return Feature.isEnabled(this.features, feature);
    }

    public final String null_string() {
        if (this.hasFeature(Feature.StringNullAsEmpty)) {
            return "";
        }
        return null;
    }
}

