/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.utils;

import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Clob;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.noear.snack.core.exts.FieldWrap;

public class BeanUtil {
    public static final Map<String, Class<?>> clzCached = new ConcurrentHashMap();
    private static final transient Map<String, Collection<FieldWrap>> fieldsCached = new HashMap<String, Collection<FieldWrap>>();

    public static Class<?> loadClass(String clzName) {
        try {
            Class<?> clz = clzCached.get(clzName);
            if (clz == null) {
                clz = Class.forName(clzName);
                clzCached.put(clzName, clz);
            }
            return clz;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<FieldWrap> getAllFields(Class<?> clz) {
        String key = clz.getName();
        Collection<FieldWrap> list = fieldsCached.get(key);
        if (list == null) {
            String string = key.intern();
            synchronized (string) {
                list = fieldsCached.get(key);
                if (list == null) {
                    LinkedHashMap map = new LinkedHashMap();
                    BeanUtil.scanAllFields(clz, map::containsKey, map::put);
                    list = map.values();
                    fieldsCached.put(key, list);
                }
            }
        }
        return list;
    }

    private static void scanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
            f.setAccessible(true);
            if (checker.test(f.getName())) continue;
            consumer.accept(f.getName(), new FieldWrap(clz, f));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            BeanUtil.scanAllFields(sup, checker, consumer);
        }
    }

    public static String clobToString(Clob clob) {
        Reader reader = null;
        StringBuilder buf = new StringBuilder();
        try {
            int len;
            reader = clob.getCharacterStream();
            char[] chars = new char[2048];
            while ((len = reader.read(chars, 0, chars.length)) >= 0) {
                buf.append(chars, 0, len);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("read string from reader error", ex);
        }
        String text = buf.toString();
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception ex) {
                throw new RuntimeException("read string from reader error", ex);
            }
        }
        return text;
    }
}

