/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.exts;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.noear.snack.core.exts.FieldWrap;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> cached = new ConcurrentHashMap();
    private final Class<?> _clz;
    private final Collection<FieldWrap> _fieldAllWraps;

    public static ClassWrap get(Class<?> clz) {
        ClassWrap l;
        ClassWrap cw = cached.get(clz);
        if (cw == null && (l = cached.putIfAbsent(clz, cw = new ClassWrap(clz))) != null) {
            cw = l;
        }
        return cw;
    }

    protected ClassWrap(Class<?> clz) {
        this._clz = clz;
        LinkedHashMap map = new LinkedHashMap();
        ClassWrap.scanAllFields(clz, map::containsKey, map::put);
        this._fieldAllWraps = map.values();
    }

    public Class<?> clz() {
        return this._clz;
    }

    public Collection<FieldWrap> fieldAllWraps() {
        return this._fieldAllWraps;
    }

    private static void scanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || Modifier.isTransient(mod)) continue;
            f.setAccessible(true);
            if (checker.test(f.getName())) continue;
            consumer.accept(f.getName(), new FieldWrap(clz, f));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            ClassWrap.scanAllFields(sup, checker, consumer);
        }
    }
}

