/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.noear.snack.core.exts.EnumWrap;
import org.noear.snack.core.exts.ParameterizedTypeImpl;
import org.noear.snack.exception.SnackException;

public class TypeUtil {
    public static final BigInteger INT_LOW = BigInteger.valueOf(-9007199254740991L);
    public static final BigInteger INT_HIGH = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
    public static final BigDecimal DEC_LOW = BigDecimal.valueOf(-9007199254740991L);
    public static final BigDecimal DEC_HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
    private static Map<String, EnumWrap> enumCached = new ConcurrentHashMap<String, EnumWrap>();
    private static final Map<Type, Map<TypeVariable, Type>> genericInfoCached = new HashMap<Type, Map<TypeVariable, Type>>();

    public static Object strTo(String str, Class<?> clz) {
        if (Integer.class.isAssignableFrom(clz) || Integer.TYPE == clz) {
            return Integer.parseInt(str);
        }
        if (Long.class.isAssignableFrom(clz) || Long.TYPE == clz) {
            return Long.parseLong(str);
        }
        throw new SnackException("unsupport type " + str);
    }

    public static EnumWrap createEnum(Class<?> clz) {
        String key = clz.getName();
        EnumWrap val = enumCached.get(key);
        if (val == null) {
            val = new EnumWrap(clz);
            enumCached.put(key, val);
        }
        return val;
    }

    public static Type getCollectionItemType(Type fieldType) {
        if (fieldType instanceof ParameterizedType) {
            return TypeUtil.getCollectionItemType((ParameterizedType)fieldType);
        }
        if (fieldType instanceof Class) {
            return TypeUtil.getCollectionItemType((Class)fieldType);
        }
        return Object.class;
    }

    private static Type getCollectionItemType(Class<?> clazz) {
        return clazz.getName().startsWith("java.") ? Object.class : TypeUtil.getCollectionItemType(TypeUtil.getCollectionSuperType(clazz));
    }

    private static Type getCollectionSuperType(Class<?> clazz) {
        Type assignable = null;
        for (Type type : clazz.getGenericInterfaces()) {
            Class<?> rawClass = TypeUtil.getRawClass(type);
            if (rawClass == Collection.class) {
                return type;
            }
            if (!Collection.class.isAssignableFrom(rawClass)) continue;
            assignable = type;
        }
        return assignable == null ? clazz.getGenericSuperclass() : assignable;
    }

    private static Type getCollectionItemType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (rawType == Collection.class) {
            return TypeUtil.getWildcardTypeUpperBounds(actualTypeArguments[0]);
        }
        Class rawClass = (Class)rawType;
        Map<TypeVariable, Type> typeParameterMap = TypeUtil.createTypeParameterMap(rawClass.getTypeParameters(), actualTypeArguments);
        Type superType = TypeUtil.getCollectionSuperType(rawClass);
        if (superType instanceof ParameterizedType) {
            Class<?> superClass = TypeUtil.getRawClass(superType);
            Type[] superClassTypeParameters = ((ParameterizedType)superType).getActualTypeArguments();
            return superClassTypeParameters.length > 0 ? TypeUtil.getCollectionItemType(TypeUtil.makeParameterizedType(superClass, superClassTypeParameters, typeParameterMap)) : TypeUtil.getCollectionItemType(superClass);
        }
        return TypeUtil.getCollectionItemType((Class)superType);
    }

    private static Map<TypeVariable, Type> createTypeParameterMap(TypeVariable[] typeParameters, Type[] actualTypeArguments) {
        int length = typeParameters.length;
        HashMap<TypeVariable, Type> typeParameterMap = new HashMap<TypeVariable, Type>(length);
        for (int i = 0; i < length; ++i) {
            typeParameterMap.put(typeParameters[i], actualTypeArguments[i]);
        }
        return typeParameterMap;
    }

    private static ParameterizedType makeParameterizedType(Class<?> rawClass, Type[] typeParameters, Map<TypeVariable, Type> typeParameterMap) {
        int length = typeParameters.length;
        Type[] actualTypeArguments = new Type[length];
        System.arraycopy(typeParameters, 0, actualTypeArguments, 0, length);
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            Type actualTypeArgument = actualTypeArguments[i];
            if (!(actualTypeArgument instanceof TypeVariable)) continue;
            actualTypeArguments[i] = typeParameterMap.get(actualTypeArgument);
        }
        return new ParameterizedTypeImpl(actualTypeArguments, null, rawClass);
    }

    private static Type getWildcardTypeUpperBounds(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            return upperBounds.length > 0 ? upperBounds[0] : Object.class;
        }
        return type;
    }

    public static Collection createCollection(Type type, boolean isThrow) {
        Collection<Object> list;
        if (type == null) {
            return new ArrayList();
        }
        if (type == ArrayList.class) {
            return new ArrayList();
        }
        Class<AbstractCollection> rawClass = TypeUtil.getRawClass(type);
        if (rawClass == AbstractCollection.class || rawClass == Collection.class) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (rawClass.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (rawClass.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (rawClass.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(EnumSet.class)) {
            Object itemType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
            list = EnumSet.noneOf(itemType);
        } else {
            try {
                list = (Collection)rawClass.newInstance();
            }
            catch (Exception e) {
                if (isThrow) {
                    throw new SnackException("create instance error, class " + rawClass.getName());
                }
                return null;
            }
        }
        return list;
    }

    public static Map createMap(Type type) {
        if (type == null) {
            return new HashMap();
        }
        if (type == HashMap.class) {
            return new HashMap();
        }
        if (type == Properties.class) {
            return new Properties();
        }
        if (type == Hashtable.class) {
            return new Hashtable();
        }
        if (type == IdentityHashMap.class) {
            return new IdentityHashMap();
        }
        if (type == SortedMap.class || type == TreeMap.class) {
            return new TreeMap();
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return new ConcurrentHashMap();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (type == Map.class) {
            return new HashMap();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (EnumMap.class.equals((Object)rawType)) {
                Type[] actualArgs = parameterizedType.getActualTypeArguments();
                return new EnumMap((Class)actualArgs[0]);
            }
            return TypeUtil.createMap(rawType);
        }
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            throw new SnackException("unsupport type " + type);
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw new SnackException("unsupport type " + type, e);
        }
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtil.getRawClass(((ParameterizedType)type).getRawType());
        }
        throw new SnackException("unsupport type " + type);
    }

    public static ParameterizedType toParameterizedType(Type type) {
        ParameterizedType result = null;
        if (type instanceof ParameterizedType) {
            result = (ParameterizedType)type;
        } else if (type instanceof Class) {
            Type[] genericInterfaces;
            Class clazz = (Class)type;
            Type genericSuper = clazz.getGenericSuperclass();
            if ((null == genericSuper || Object.class.equals((Object)genericSuper)) && (genericInterfaces = clazz.getGenericInterfaces()) != null && genericInterfaces.length > 0) {
                genericSuper = genericInterfaces[0];
            }
            result = TypeUtil.toParameterizedType(genericSuper);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<TypeVariable, Type> getGenericInfo(Type type) {
        Map<TypeVariable, Type> tmp = genericInfoCached.get(type);
        if (tmp == null) {
            Type type2 = type;
            synchronized (type2) {
                tmp = genericInfoCached.get(type);
                if (tmp == null) {
                    tmp = TypeUtil.createTypeGenericMap(type);
                    genericInfoCached.put(type, tmp);
                }
            }
        }
        return tmp;
    }

    private static Map<TypeVariable, Type> createTypeGenericMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<TypeVariable, Type> typeMap = new HashMap<TypeVariable, Type>();
        while (null != type && null != (parameterizedType = TypeUtil.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type value = typeArguments[i];
                if (value instanceof TypeVariable) continue;
                typeMap.put(typeParameters[i], value);
            }
            type = rawType;
        }
        return typeMap;
    }
}

