/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.to;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.snack.ONodeData;
import org.noear.snack.OValue;
import org.noear.snack.OValueType;
import org.noear.snack.core.Context;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.NodeDecoderEntity;
import org.noear.snack.core.exts.ClassWrap;
import org.noear.snack.core.exts.EnumWrap;
import org.noear.snack.core.exts.FieldWrap;
import org.noear.snack.core.exts.ParameterizedTypeImpl;
import org.noear.snack.core.utils.BeanUtil;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.core.utils.TypeUtil;
import org.noear.snack.exception.SnackException;
import org.noear.snack.to.Toer;

public class ObjectToer
implements Toer {
    @Override
    public void handle(Context ctx) throws Exception {
        ONode o = (ONode)ctx.source;
        if (null != o) {
            ctx.target = this.analyse(ctx, o, ctx.target_clz, ctx.target_type, null);
        }
    }

    private Object analyse(Context ctx, ONode o, Class<?> clz, Type type, Map<TypeVariable, Type> genericInfo) throws Exception {
        if (o == null) {
            return null;
        }
        if (clz != null && ONode.class.isAssignableFrom(clz)) {
            return o;
        }
        if (o.isObject() || o.isArray()) {
            clz = this.getTypeByNode(ctx, o, clz);
        }
        if (clz != null) {
            for (NodeDecoderEntity decoder : ctx.options.decoders()) {
                if (!decoder.isDecodable(clz)) continue;
                return decoder.decode(o, clz);
            }
        }
        if (String.class == clz) {
            return o.getString();
        }
        switch (o.nodeType()) {
            case Value: {
                return this.analyseVal(ctx, o.nodeData(), clz);
            }
            case Object: {
                o.remove(ctx.options.getTypePropertyName());
                if (Map.class.isAssignableFrom(clz)) {
                    return this.analyseMap(ctx, o, clz, type, genericInfo);
                }
                if (StackTraceElement.class.isAssignableFrom(clz)) {
                    String declaringClass = o.get("declaringClass").getString();
                    if (declaringClass == null) {
                        declaringClass = o.get("className").getString();
                    }
                    return new StackTraceElement(declaringClass, o.get("methodName").getString(), o.get("fileName").getString(), o.get("lineNumber").getInt());
                }
                if (type instanceof ParameterizedType) {
                    genericInfo = TypeUtil.getGenericInfo(type);
                }
                return this.analyseBean(ctx, o, clz, type, genericInfo);
            }
            case Array: {
                if (clz.isArray()) {
                    return this.analyseArray(ctx, o.nodeData(), clz);
                }
                return this.analyseCollection(ctx, o, clz, type, genericInfo);
            }
        }
        return null;
    }

    private boolean is(Class<?> s, Class<?> t) {
        return s.isAssignableFrom(t);
    }

    public Object analyseVal(Context ctx, ONodeData d, Class<?> clz) throws Exception {
        OValue v = d.value;
        if (v.type() == OValueType.Null) {
            return null;
        }
        if (clz == null) {
            return v.getRaw();
        }
        if (this.is(Byte.class, clz) || clz == Byte.TYPE) {
            return (byte)v.getLong();
        }
        if (this.is(Short.class, clz) || clz == Short.TYPE) {
            return v.getShort();
        }
        if (this.is(Integer.class, clz) || clz == Integer.TYPE) {
            return v.getInt();
        }
        if (this.is(Long.class, clz) || clz == Long.TYPE) {
            return v.getLong();
        }
        if (this.is(Float.class, clz) || clz == Float.TYPE) {
            return Float.valueOf(v.getFloat());
        }
        if (this.is(Double.class, clz) || clz == Double.TYPE) {
            return v.getDouble();
        }
        if (this.is(Boolean.class, clz) || clz == Boolean.TYPE) {
            return v.getBoolean();
        }
        if (this.is(Character.class, clz) || clz == Character.TYPE) {
            return Character.valueOf(v.getChar());
        }
        if (this.is(String.class, clz)) {
            return v.getString();
        }
        if (this.is(Timestamp.class, clz)) {
            return new Timestamp(v.getLong());
        }
        if (this.is(Date.class, clz)) {
            return new Date(v.getLong());
        }
        if (this.is(Time.class, clz)) {
            return new Time(v.getLong());
        }
        if (this.is(java.util.Date.class, clz)) {
            return v.getDate();
        }
        if (this.is(LocalDateTime.class, clz)) {
            return v.getDate().toInstant().atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toLocalDateTime();
        }
        if (this.is(LocalDate.class, clz)) {
            return v.getDate().toInstant().atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toLocalDate();
        }
        if (this.is(LocalTime.class, clz)) {
            return v.getDate().toInstant().atZone(DEFAULTS.DEF_TIME_ZONE.toZoneId()).toLocalTime();
        }
        if (this.is(BigDecimal.class, clz)) {
            if (v.type() == OValueType.Number && v.getRawNumber() instanceof BigDecimal) {
                return v.getRawNumber();
            }
            return new BigDecimal(v.getString());
        }
        if (this.is(BigInteger.class, clz)) {
            if (v.type() == OValueType.Number && v.getRawNumber() instanceof BigInteger) {
                return v.getRawNumber();
            }
            return new BigInteger(v.getString());
        }
        if (clz.isEnum()) {
            return this.analyseEnum(ctx, d, clz);
        }
        if (this.is(Class.class, clz)) {
            return BeanUtil.loadClass(v.getString());
        }
        if (this.is(Object.class, clz)) {
            return v.getRaw();
        }
        throw new SnackException("unsupport type " + clz.getName());
    }

    public Object analyseEnum(Context ctx, ONodeData d, Class<?> target) {
        EnumWrap ew = TypeUtil.createEnum(target);
        if (d.value.type() == OValueType.String) {
            return ew.get(d.value.getString());
        }
        return ew.get(d.value.getInt());
    }

    public Object analyseArray(Context ctx, ONodeData d, Class<?> target) throws Exception {
        int len = d.array.size();
        if (this.is(byte[].class, target)) {
            byte[] val = new byte[len];
            for (int i = 0; i < len; ++i) {
                val[i] = (byte)d.array.get(i).getLong();
            }
            return val;
        }
        if (this.is(short[].class, target)) {
            short[] val = new short[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getShort();
            }
            return val;
        }
        if (this.is(int[].class, target)) {
            int[] val = new int[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getInt();
            }
            return val;
        }
        if (this.is(long[].class, target)) {
            long[] val = new long[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getLong();
            }
            return val;
        }
        if (this.is(float[].class, target)) {
            float[] val = new float[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getFloat();
            }
            return val;
        }
        if (this.is(double[].class, target)) {
            double[] val = new double[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getDouble();
            }
            return val;
        }
        if (this.is(boolean[].class, target)) {
            boolean[] val = new boolean[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getBoolean();
            }
            return val;
        }
        if (this.is(char[].class, target)) {
            char[] val = new char[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getChar();
            }
            return val;
        }
        if (this.is(String[].class, target)) {
            String[] val = new String[len];
            for (int i = 0; i < len; ++i) {
                val[i] = d.array.get(i).getString();
            }
            return val;
        }
        if (this.is(Object[].class, target)) {
            Class<?> c = target.getComponentType();
            Object[] val = (Object[])Array.newInstance(c, len);
            for (int i = 0; i < len; ++i) {
                val[i] = this.analyse(ctx, d.array.get(i), c, c, null);
            }
            return val;
        }
        throw new SnackException("unsupport type " + target.getName());
    }

    public Object analyseCollection(Context ctx, ONode o, Class<?> clz, Type type, Map<TypeVariable, Type> genericInfo) throws Exception {
        Collection list = TypeUtil.createCollection(clz, false);
        if (list == null) {
            return null;
        }
        Type itemType = null;
        if (ctx.target_type != null) {
            itemType = TypeUtil.getCollectionItemType(type);
        }
        if (itemType != null && itemType instanceof TypeVariable) {
            itemType = null;
        }
        for (ONode o1 : o.nodeData().array) {
            list.add(this.analyse(ctx, o1, (Class)itemType, itemType, genericInfo));
        }
        return list;
    }

    public Object analyseMap(Context ctx, ONode o, Class<?> clz, Type type, Map<TypeVariable, Type> genericInfo) throws Exception {
        Map map = TypeUtil.createMap(clz);
        if (type instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)type;
            Type kType = ptt.getActualTypeArguments()[0];
            Type vType = ptt.getActualTypeArguments()[1];
            if (kType instanceof ParameterizedType) {
                kType = ((ParameterizedType)kType).getRawType();
            }
            if (vType instanceof ParameterizedType) {
                vType = ((ParameterizedType)vType).getRawType();
            }
            if (kType == String.class) {
                for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                    map.put(kv.getKey(), this.analyse(ctx, kv.getValue(), (Class)vType, vType, genericInfo));
                }
            } else {
                for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                    map.put(TypeUtil.strTo(kv.getKey(), (Class)kType), this.analyse(ctx, kv.getValue(), (Class)vType, vType, genericInfo));
                }
            }
        } else {
            for (Map.Entry<String, ONode> kv : o.nodeData().object.entrySet()) {
                map.put(kv.getKey(), this.analyse(ctx, kv.getValue(), null, null, genericInfo));
            }
        }
        return map;
    }

    public Object analyseBean(Context ctx, ONode o, Class<?> clz, Type type, Map<TypeVariable, Type> genericInfo) throws Exception {
        String message;
        if (this.is(SimpleDateFormat.class, clz)) {
            return new SimpleDateFormat(o.get("val").getString());
        }
        if (this.is(InetSocketAddress.class, clz)) {
            return new InetSocketAddress(o.get("address").getString(), o.get("port").getInt());
        }
        Object rst = null;
        if (this.is(Throwable.class, clz) && !StringUtil.isEmpty(message = o.get("message").getString())) {
            try {
                Constructor<?> fun = clz.getConstructor(String.class);
                rst = fun.newInstance(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rst == null) {
            rst = BeanUtil.newInstance(clz);
        }
        Collection<FieldWrap> list = ClassWrap.get(clz).fieldAllWraps();
        for (FieldWrap f : list) {
            String key;
            if (!f.isDeserialize() || !o.contains(key = f.getName())) continue;
            Class fieldT = f.type;
            Type fieldGt = f.genericType;
            if (genericInfo != null) {
                Type tmp;
                if (fieldGt instanceof TypeVariable && (tmp = genericInfo.get(fieldGt)) != null) {
                    fieldGt = tmp;
                    if (tmp instanceof Class) {
                        fieldT = (Class)tmp;
                    }
                }
                if (fieldGt instanceof ParameterizedType) {
                    ParameterizedType fieldGt2 = (ParameterizedType)fieldGt;
                    Type[] actualTypes = fieldGt2.getActualTypeArguments();
                    boolean actualTypesChanged = false;
                    fieldT = (Class)fieldGt2.getRawType();
                    int len = actualTypes.length;
                    for (int i = 0; i < len; ++i) {
                        Type tmp2 = actualTypes[i];
                        if (!(tmp2 instanceof TypeVariable) || (tmp2 = genericInfo.get(tmp2)) == null) continue;
                        actualTypes[i] = tmp2;
                        actualTypesChanged = true;
                    }
                    if (actualTypesChanged) {
                        fieldGt = new ParameterizedTypeImpl(actualTypes, fieldGt2.getOwnerType(), fieldGt2.getRawType());
                    }
                }
            }
            Object val = this.analyse(ctx, o.get(key), fieldT, fieldGt, genericInfo);
            f.setValue(rst, val);
        }
        return rst;
    }

    private Class<?> getTypeByNode(Context ctx, ONode o, Class<?> def) {
        ONode n1;
        ONode n12;
        ONode o1;
        if (ctx.target_type == null) {
            if (o.isObject()) {
                return LinkedHashMap.class;
            }
            if (o.isArray()) {
                return ArrayList.class;
            }
        }
        String typeStr = null;
        if (o.isArray() && o.ary().size() == 2 && (o1 = o.ary().get(0)).isObject() && o1.obj().size() == 1 && (n12 = o1.obj().get(ctx.options.getTypePropertyName())) != null) {
            typeStr = n12.val().getString();
        }
        if (o.isObject() && (n1 = o.obj().get(ctx.options.getTypePropertyName())) != null) {
            typeStr = n1.val().getString();
        }
        if (!StringUtil.isEmpty(typeStr)) {
            Class<?> clz = BeanUtil.loadClass(typeStr);
            if (clz == null) {
                throw new SnackException("unsupport type " + typeStr);
            }
            return clz;
        }
        if (def == null || def == Object.class) {
            if (o.isObject()) {
                return LinkedHashMap.class;
            }
            if (o.isArray()) {
                return ArrayList.class;
            }
        }
        return def;
    }
}

