/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.snowflake.service;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.extend.snowflake.service.CloudIdServiceImp;
import org.noear.solon.cloud.service.CloudIdService;
import org.noear.solon.cloud.service.CloudIdServiceFactory;

public class CloudIdServiceFactoryImp
implements CloudIdServiceFactory {
    long idStart;
    long workId;
    private Map<String, CloudIdService> cached = new HashMap<String, CloudIdService>();

    public CloudIdServiceFactoryImp(CloudProps cloudProps) {
        this.idStart = cloudProps.getIdStart();
        this.workId = Long.parseLong(cloudProps.getValue("id.workId", "0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudIdService create(String group, String service) {
        String block = group + "_" + service;
        CloudIdService tmp = this.cached.get(block);
        if (tmp == null) {
            Utils.locker().lock();
            try {
                tmp = this.cached.get(block);
                if (tmp == null) {
                    tmp = new CloudIdServiceImp(block, this.workId, this.idStart);
                    this.cached.put(block, tmp);
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return tmp;
    }
}

