/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.snowflake.impl;

import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.cloud.model.Instance;

public class SnowflakeId {
    private static final long START_TIME_DEF = 1577808000000L;
    private final int timeLen = 41;
    private final int dataLen = 5;
    private final int workLen = 5;
    private final int seqLen = 12;
    private final long startTime;
    private long lastTimeStamp = -1L;
    private final int timeLeftBit = 22;
    private final long dataId;
    private final long workId;
    private final int dataMaxNum = 31;
    private final int workMaxNum = 31;
    private final int dataRandom = 32;
    private final int workRandom = 32;
    private final int dataLeftBit = 17;
    private final int workLeftBit = 12;
    private long seqLastVal = 0L;
    private final long seqMaxNum = 4095L;
    private final ReentrantLock ID_LOCK = new ReentrantLock();

    public SnowflakeId(String dataBlock, long workId, long startTime) {
        this.startTime = startTime > 0L ? startTime : 1577808000000L;
        this.dataId = this.getDataId(dataBlock);
        this.workId = workId > 0L ? workId : (long)this.getWorkId();
    }

    public SnowflakeId(long dataId, long workId) {
        this(dataId, workId, 1577808000000L);
    }

    public SnowflakeId(long dataId, long workId, long startTime) {
        if (dataId > 31L || dataId < 0L) {
            throw new IllegalArgumentException("dataId can't be greater than DATA_MAX_NUM or less than 0");
        }
        if (workId > 31L || workId < 0L) {
            throw new IllegalArgumentException("workId can't be greater than WORK_MAX_NUM or less than 0");
        }
        this.startTime = startTime > 0L ? startTime : 1577808000000L;
        this.dataId = dataId;
        this.workId = workId;
    }

    public long nextId() {
        this.ID_LOCK.lock();
        try {
            long l = this.nextId0();
            return l;
        }
        finally {
            this.ID_LOCK.unlock();
        }
    }

    private long nextId0() {
        long now = System.currentTimeMillis();
        if (now < this.lastTimeStamp) {
            throw new IllegalStateException("System time error refused to generate snowflake ID!");
        }
        if (now == this.lastTimeStamp) {
            this.seqLastVal = this.seqLastVal + 1L & 0xFFFL;
            if (this.seqLastVal == 0L) {
                now = this.nextMillis(this.lastTimeStamp);
            }
        } else {
            this.seqLastVal = 0L;
        }
        this.lastTimeStamp = now;
        return now - this.startTime << 22 | this.dataId << 17 | this.workId << 12 | this.seqLastVal;
    }

    protected long nextMillis(long lastMillis) {
        long now = System.currentTimeMillis();
        while (now <= lastMillis) {
            now = System.currentTimeMillis();
        }
        return now;
    }

    protected int getWorkId() {
        try {
            return this.getHostId(Instance.local().address(), 31);
        }
        catch (Exception e) {
            return new Random().nextInt(32);
        }
    }

    protected int getDataId(String dataBlock) {
        try {
            return this.getHostId(dataBlock, 31);
        }
        catch (Exception e) {
            return new Random().nextInt(32);
        }
    }

    private int getHostId(String s, int max) {
        byte[] bytes = s.getBytes();
        int sums = 0;
        for (byte b : bytes) {
            sums += b;
        }
        return sums % (max + 1);
    }
}

