/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.solon.mvc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.noear.socketd.solon.mvc.SocketMvcSessionState;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.util.IoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketMvcContext
extends ContextEmpty {
    static final Logger log = LoggerFactory.getLogger(SocketMvcContext.class);
    private Session _session;
    private Message _request;
    private EntityDefault _response;
    private MethodType _method;
    private URI _uri;
    ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();

    public SocketMvcContext(Session session, Message message) throws IOException {
        this._session = session;
        this._request = message;
        this._response = new EntityDefault();
        String scheme = session.getHandshaker().getUri().getScheme();
        this._method = scheme.startsWith("ws") ? MethodType.WEBSOCKET : MethodType.SOCKET;
        if (session.getHandshaker().getParamMap().size() > 0) {
            this.headerMap().putAll(session.getHandshaker().getParamMap());
        }
        if (Utils.isNotEmpty((String)message.getEntity().getMetaString())) {
            this.headerMap().putAll(message.getEntity().getMetaMap());
        }
        if (session.getHandshaker().getParamMap().size() > 0) {
            this.paramMap().putAll(session.getHandshaker().getParamMap());
        }
        this.sessionState = new SocketMvcSessionState(this._session);
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        try {
            return this._session.getRemoteAddress().getAddress().toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int remotePort() {
        try {
            return this._session.getRemoteAddress().getPort();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isMultipart() {
        return false;
    }

    public String method() {
        return this._method.name;
    }

    public String protocol() {
        if (this._method == MethodType.WEBSOCKET) {
            return "WS";
        }
        return "SOCKET";
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String url() {
        return this._request.getTopic();
    }

    public long contentLength() {
        if (this._request.getEntity().getData() == null) {
            return 0L;
        }
        return this._request.getEntity().getDataSize();
    }

    public String contentType() {
        return (String)this.headerMap().get((Object)"Content-Type");
    }

    public String queryString() {
        return this.uri().getQuery();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getEntity().getData();
    }

    public Object response() {
        return this._session;
    }

    public void contentType(String contentType) {
        this.headerSet("Content-Type", contentType);
    }

    public void headerSet(String key, String val) {
        this._response.putMeta(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.putMeta(key, val);
    }

    public String headerOfResponse(String name) {
        return this._response.getMeta(name);
    }

    public OutputStream outputStream() {
        return this._outputStream;
    }

    public void output(byte[] bytes) {
        try {
            this._outputStream.write(bytes);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            IoUtil.transferTo((InputStream)stream, (OutputStream)this._outputStream);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void commit() throws IOException {
        if (this._session.isValid()) {
            if (this._request.isRequest() || this._request.isSubscribe()) {
                this._response.setData(this._outputStream.toByteArray());
                this._response.setMetaMap((Map)this.headerMap());
                this._session.replyEnd(this._request, (Entity)this._response);
            } else if (this._outputStream.size() > 0) {
                log.warn("No reply is supported for the current message, key={}", (Object)this._request.getKey());
            }
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public void asyncStart(long timeout, ContextAsyncListener listener) {
    }

    public void asyncComplete() {
    }

    public void close() throws IOException {
        this._session.close();
    }
}

