/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.solon.integration;

import java.util.ArrayList;
import java.util.List;
import org.noear.socketd.SocketD;
import org.noear.socketd.solon.annotation.SocketdClient;
import org.noear.socketd.solon.annotation.SocketdServer;
import org.noear.socketd.transport.client.Client;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.RunUtil;

public class XPluginImpl
implements Plugin {
    List<Server> serverList = new ArrayList<Server>();
    List<Client> clientList = new ArrayList<Client>();

    public void start(AppContext context) throws Throwable {
        context.beanBuilderAdd(SocketdServer.class, (clz, bw, anno) -> {
            if (bw.raw() instanceof Listener) {
                for (String s : anno.schema()) {
                    Server server = SocketD.createServer((ServerConfig)new ServerConfig(s));
                    server.listen((Listener)bw.raw());
                    this.serverList.add(server);
                    EventBus.publish((Object)server);
                }
            }
        });
        context.beanBuilderAdd(SocketdClient.class, (clz, bw, anno) -> {
            if (bw.raw() instanceof Listener) {
                Client client = SocketD.createClient((String)anno.url());
                client.config(options -> options.autoReconnect(anno.autoReconnect()).heartbeatInterval((long)(anno.heartbeatRate() * 1000))).listen((Listener)bw.raw());
                this.clientList.add(client);
            }
        });
        context.lifecycle(-99, new LifecycleBean(){

            public void start() throws Throwable {
                for (Server server : XPluginImpl.this.serverList) {
                    server.start();
                }
            }

            public void stop() throws Throwable {
                for (Server server : XPluginImpl.this.serverList) {
                    RunUtil.runAndTry(() -> ((Server)server).stop());
                }
            }
        });
        context.lifecycle(99, () -> {
            for (Client client : this.clientList) {
                client.open();
            }
        });
    }
}

