/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.buffer.ByteBufferReader;
import org.noear.socketd.transport.smartsocket.TcpAioBufferWriter;
import org.noear.socketd.transport.smartsocket.impl.ChannelDefaultEx;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.extension.decoder.FixedLengthFrameDecoder;
import org.smartboot.socket.transport.AioSession;

public class TcpAioChannelAssistant
implements ChannelAssistant<AioSession>,
Protocol<Frame> {
    private final Config config;

    public TcpAioChannelAssistant(Config config) {
        this.config = config;
    }

    private ChannelDefaultEx getChannel(AioSession s) {
        return ChannelDefaultEx.get(s, this.config, this);
    }

    public void write(AioSession source, Frame frame) throws IOException {
        this.config.getCodec().write(frame, i -> new TcpAioBufferWriter(source.writeBuffer()));
    }

    public boolean isValid(AioSession target) {
        return !target.isInvalid();
    }

    public void close(AioSession target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(AioSession target) throws IOException {
        return target.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress(AioSession target) throws IOException {
        return target.getLocalAddress();
    }

    public Frame decode(ByteBuffer buffer, AioSession aioSession) {
        FixedLengthFrameDecoder decoder = this.getChannel(aioSession).getDecoder();
        if (decoder == null) {
            if (buffer.remaining() < 4) {
                return null;
            }
            buffer.mark();
            decoder = new FixedLengthFrameDecoder(buffer.getInt());
            buffer.reset();
            this.getChannel(aioSession).setDecoder(decoder);
        }
        if (!decoder.decode(buffer)) {
            return null;
        }
        this.getChannel(aioSession).setDecoder(null);
        buffer = decoder.getBuffer();
        return this.config.getCodec().read((Object)new ByteBufferReader(buffer));
    }
}

