/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.impl;

import java.util.concurrent.CompletableFuture;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Flag;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.TcpAioChannelAssistant;
import org.noear.socketd.transport.smartsocket.TcpAioClient;
import org.noear.socketd.transport.smartsocket.impl.ChannelDefaultEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.transport.AioSession;

public class ClientMessageProcessor
extends AbstractMessageProcessor<Frame> {
    private static final Logger log = LoggerFactory.getLogger(ClientMessageProcessor.class);
    private TcpAioClient client;
    private CompletableFuture<ClientHandshakeResult> handshakeFuture = new CompletableFuture();

    public ClientMessageProcessor(TcpAioClient client) {
        this.client = client;
    }

    public CompletableFuture<ClientHandshakeResult> getHandshakeFuture() {
        return this.handshakeFuture;
    }

    private ChannelDefaultEx getChannel(AioSession s) {
        return ChannelDefaultEx.get(s, (Config)this.client.config(), (TcpAioChannelAssistant)this.client.assistant());
    }

    public void process0(AioSession s, Frame frame) {
        ChannelDefaultEx channel = this.getChannel(s);
        try {
            this.client.processor().onReceive((Channel)channel, frame);
            if (frame.getFlag() == Flag.Connack) {
                this.handshakeFuture.complete(new ClientHandshakeResult((ChannelInternal)channel, null));
            }
        }
        catch (Exception e) {
            if (e instanceof SocketdConnectionException) {
                this.handshakeFuture.complete(new ClientHandshakeResult((ChannelInternal)channel, e));
                return;
            }
            if (channel == null) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            this.client.processor().onError((Channel)channel, (Throwable)e);
        }
    }

    public void stateEvent0(AioSession s, StateMachineEnum state, Throwable e) {
        switch (state) {
            case NEW_SESSION: {
                ChannelDefaultEx channel = this.getChannel(s);
                try {
                    channel.sendConnect(this.client.config().getUrl());
                }
                catch (Throwable ex) {
                    this.client.processor().onError((Channel)channel, ex);
                }
                break;
            }
            case SESSION_CLOSED: {
                this.client.processor().onClose((Channel)this.getChannel(s));
                break;
            }
            case PROCESS_EXCEPTION: 
            case DECODE_EXCEPTION: 
            case INPUT_EXCEPTION: 
            case ACCEPT_EXCEPTION: 
            case OUTPUT_EXCEPTION: {
                this.client.processor().onError((Channel)this.getChannel(s), e);
            }
        }
    }
}

