/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.impl.Attachment;
import org.noear.socketd.transport.smartsocket.impl.FixedLengthFrameDecoder;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioSession;

public class TcpAioChannelAssistant
implements ChannelAssistant<AioSession>,
Protocol<Frame> {
    private final Config config;

    public TcpAioChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(AioSession source, Frame frame) throws IOException {
        ByteBuffer buf = (ByteBuffer)this.config.getCodec().encode(frame);
        source.writeBuffer().writeAndFlush(buf.array());
    }

    public boolean isValid(AioSession target) {
        return !target.isInvalid();
    }

    public void close(AioSession target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(AioSession target) throws IOException {
        return target.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress(AioSession target) throws IOException {
        return target.getLocalAddress();
    }

    public Frame decode(ByteBuffer buffer, AioSession aioSession) {
        FixedLengthFrameDecoder decoder = Attachment.getDecoder(aioSession);
        if (decoder == null) {
            if (buffer.remaining() < 4) {
                return null;
            }
            buffer.mark();
            decoder = new FixedLengthFrameDecoder(buffer.getInt());
            buffer.reset();
            Attachment.setDecoder(aioSession, decoder);
        }
        if (!decoder.read(buffer)) {
            return null;
        }
        Attachment.setDecoder(aioSession, null);
        buffer = decoder.getBuffer();
        buffer.flip();
        return this.config.getCodec().decode((Object)buffer);
    }
}

