/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket;

import java.nio.channels.AsynchronousSocketChannel;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.smartsocket.TcpAioChannelAssistant;
import org.noear.socketd.transport.smartsocket.impl.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.NetMonitor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.transport.AioQuickServer;
import org.smartboot.socket.transport.AioSession;

public class TcpAioServer
extends ServerBase<TcpAioChannelAssistant>
implements MessageProcessor<Frame>,
NetMonitor {
    private static final Logger log = LoggerFactory.getLogger(TcpAioServer.class);
    private AioQuickServer server;
    private SslPlugin<Integer> sslPlugin;

    public TcpAioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new TcpAioChannelAssistant((Config)config));
    }

    public Server start() throws Exception {
        if (this.isStarted) {
            throw new IllegalStateException("Server started");
        }
        this.isStarted = true;
        this.server = this.config().getHost() != null ? new AioQuickServer(this.config().getPort(), (Protocol)this.assistant(), (MessageProcessor)this) : new AioQuickServer(this.config().getHost(), this.config().getPort(), (Protocol)this.assistant(), (MessageProcessor)this);
        if (this.config().getSslContext() != null) {
            this.sslPlugin = new SslPlugin(() -> ((ServerConfig)this.config()).getSslContext(), sslEngine -> sslEngine.setUseClientMode(false));
        }
        this.server.setThreadNum(this.config().getCoreThreads());
        this.server.setBannerEnabled(false);
        if (this.config().getReadBufferSize() > 0) {
            this.server.setReadBufferSize(this.config().getReadBufferSize());
        }
        if (this.config().getWriteBufferSize() > 0) {
            this.server.setWriteBuffer(this.config().getWriteBufferSize(), 16);
        }
        this.server.start();
        log.info("Server started: {server=" + this.config().getLocalUrl() + "}");
        return this;
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            log.debug("{}", (Throwable)e);
        }
    }

    private Channel getChannel(AioSession s) {
        return Attachment.getChannel(s, (Config)this.config(), (TcpAioChannelAssistant)this.assistant());
    }

    public void process(AioSession s, Frame frame) {
        Channel channel = this.getChannel(s);
        try {
            this.processor().onReceive(channel, frame);
        }
        catch (Throwable e) {
            if (channel == null) {
                log.warn(e.getMessage(), e);
            }
            this.processor().onError(channel.getSession(), e);
        }
    }

    public void stateEvent(AioSession s, StateMachineEnum state, Throwable e) {
        switch (state) {
            case NEW_SESSION: {
                break;
            }
            case SESSION_CLOSED: {
                this.processor().onClose(this.getChannel(s).getSession());
                break;
            }
            case PROCESS_EXCEPTION: 
            case DECODE_EXCEPTION: 
            case INPUT_EXCEPTION: 
            case ACCEPT_EXCEPTION: 
            case OUTPUT_EXCEPTION: {
                this.processor().onError(this.getChannel(s).getSession(), e);
            }
        }
    }

    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel asynchronousSocketChannel) {
        if (this.sslPlugin == null) {
            return asynchronousSocketChannel;
        }
        return this.sslPlugin.shouldAccept(asynchronousSocketChannel);
    }

    public void afterRead(AioSession aioSession, int i) {
    }

    public void beforeRead(AioSession aioSession) {
    }

    public void afterWrite(AioSession aioSession, int i) {
    }

    public void beforeWrite(AioSession aioSession) {
    }
}

