/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketdTimeoutException;
import org.noear.socketd.transport.client.ClientBase;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Flag;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.TcpAioChannelAssistant;
import org.noear.socketd.transport.smartsocket.TcpAioClient;
import org.noear.socketd.transport.smartsocket.impl.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.NetMonitor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.transport.AioQuickClient;
import org.smartboot.socket.transport.AioSession;

public class TcpAioClientConnector
extends ClientConnectorBase<TcpAioClient>
implements MessageProcessor<Frame>,
NetMonitor {
    private static final Logger log = LoggerFactory.getLogger(TcpAioClientConnector.class);
    private AioQuickClient real;
    private CompletableFuture<Channel> future;
    private SslPlugin<Integer> sslPlugin;

    public TcpAioClientConnector(TcpAioClient client) {
        super((ClientBase)client);
    }

    public Channel connect() throws Exception {
        log.debug("Start connecting to: {}", (Object)((TcpAioClient)this.client).config().getUrl());
        this.real = new AioQuickClient(((TcpAioClient)this.client).config().getHost(), ((TcpAioClient)this.client).config().getPort(), (Protocol)((TcpAioClient)this.client).assistant(), (MessageProcessor)this);
        if (((TcpAioClient)this.client).config().getSslContext() != null) {
            this.sslPlugin = new SslPlugin(() -> ((ClientConfig)((TcpAioClient)this.client).config()).getSslContext(), sslEngine -> sslEngine.setUseClientMode(true));
        }
        if (((TcpAioClient)this.client).config().getReadBufferSize() > 0) {
            this.real.setReadBufferSize(((TcpAioClient)this.client).config().getReadBufferSize());
        }
        if (((TcpAioClient)this.client).config().getWriteBufferSize() > 0) {
            this.real.setWriteBuffer(((TcpAioClient)this.client).config().getWriteBufferSize(), 16);
        }
        if (((TcpAioClient)this.client).config().getConnectTimeout() > 0L) {
            this.real.connectTimeout((int)((TcpAioClient)this.client).config().getConnectTimeout());
        }
        this.future = new CompletableFuture();
        this.real.start();
        try {
            return this.future.get(((TcpAioClient)this.client).config().getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new SocketdTimeoutException("Connection timeout: " + ((TcpAioClient)this.client).config().getUrl());
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.real == null) {
            return;
        }
        try {
            this.real.shutdown();
        }
        catch (Throwable e) {
            log.debug("{}", e);
        }
    }

    private Channel getChannel(AioSession s) {
        return Attachment.getChannel(s, (Config)((TcpAioClient)this.client).config(), (TcpAioChannelAssistant)((TcpAioClient)this.client).assistant());
    }

    public void process(AioSession s, Frame frame) {
        Channel channel = this.getChannel(s);
        try {
            ((TcpAioClient)this.client).processor().onReceive(channel, frame);
            if (frame.getFlag() == Flag.Connack) {
                this.future.complete(channel);
            }
        }
        catch (Throwable e) {
            if (channel == null) {
                log.warn(e.getMessage(), e);
            }
            ((TcpAioClient)this.client).processor().onError(channel.getSession(), e);
        }
    }

    public void stateEvent(AioSession s, StateMachineEnum state, Throwable e) {
        switch (state) {
            case NEW_SESSION: {
                Channel channel = this.getChannel(s);
                try {
                    channel.sendConnect(((TcpAioClient)this.client).config().getUrl());
                }
                catch (Throwable ex) {
                    ((TcpAioClient)this.client).processor().onError(channel.getSession(), ex);
                }
                break;
            }
            case SESSION_CLOSED: {
                ((TcpAioClient)this.client).processor().onClose(this.getChannel(s).getSession());
                break;
            }
            case PROCESS_EXCEPTION: 
            case DECODE_EXCEPTION: 
            case INPUT_EXCEPTION: 
            case ACCEPT_EXCEPTION: 
            case OUTPUT_EXCEPTION: {
                ((TcpAioClient)this.client).processor().onError(this.getChannel(s).getSession(), e);
            }
        }
    }

    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel asynchronousSocketChannel) {
        if (this.sslPlugin == null) {
            return asynchronousSocketChannel;
        }
        return this.sslPlugin.shouldAccept(asynchronousSocketChannel);
    }

    public void afterRead(AioSession aioSession, int i) {
    }

    public void beforeRead(AioSession aioSession) {
    }

    public void afterWrite(AioSession aioSession, int i) {
    }

    public void beforeWrite(AioSession aioSession) {
    }
}

