/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.impl;

import java.util.concurrent.CompletableFuture;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Flag;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.TcpAioChannelAssistant;
import org.noear.socketd.transport.smartsocket.TcpAioClient;
import org.noear.socketd.transport.smartsocket.impl.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.transport.AioSession;

public class ClientMessageProcessor
extends AbstractMessageProcessor<Frame> {
    private static final Logger log = LoggerFactory.getLogger(ClientMessageProcessor.class);
    private TcpAioClient client;
    private CompletableFuture<Channel> channelFuture;

    public ClientMessageProcessor(TcpAioClient client) {
        this.client = client;
        this.channelFuture = new CompletableFuture();
    }

    public CompletableFuture<Channel> getChannelFuture() {
        return this.channelFuture;
    }

    private Channel getChannel(AioSession s) {
        return Attachment.getChannel(s, (Config)this.client.config(), (TcpAioChannelAssistant)this.client.assistant());
    }

    public void process0(AioSession s, Frame frame) {
        Channel channel = this.getChannel(s);
        try {
            this.client.processor().onReceive(channel, frame);
            if (frame.getFlag() == Flag.Connack) {
                this.channelFuture.complete(channel);
            }
        }
        catch (Throwable e) {
            if (channel == null) {
                log.warn(e.getMessage(), e);
            }
            this.client.processor().onError(channel.getSession(), e);
        }
    }

    public void stateEvent0(AioSession s, StateMachineEnum state, Throwable e) {
        switch (state) {
            case NEW_SESSION: {
                Channel channel = this.getChannel(s);
                try {
                    channel.sendConnect(this.client.config().getUrl());
                }
                catch (Throwable ex) {
                    this.client.processor().onError(channel.getSession(), ex);
                }
                break;
            }
            case SESSION_CLOSED: {
                this.client.processor().onClose(this.getChannel(s).getSession());
                break;
            }
            case PROCESS_EXCEPTION: 
            case DECODE_EXCEPTION: 
            case INPUT_EXCEPTION: 
            case ACCEPT_EXCEPTION: 
            case OUTPUT_EXCEPTION: {
                this.client.processor().onError(this.getChannel(s).getSession(), e);
            }
        }
    }
}

