/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket;

import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.smartsocket.TcpAioChannelAssistant;
import org.noear.socketd.transport.smartsocket.impl.ServerMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.extension.plugins.IdleStatePlugin;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.transport.AioQuickServer;

public class TcpAioServer
extends ServerBase<TcpAioChannelAssistant> {
    private static final Logger log = LoggerFactory.getLogger(TcpAioServer.class);
    private AioQuickServer server;

    public TcpAioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new TcpAioChannelAssistant((Config)config));
    }

    public Server start() throws Exception {
        if (this.isStarted) {
            throw new IllegalStateException("Server started");
        }
        this.isStarted = true;
        ServerMessageProcessor processor = new ServerMessageProcessor(this);
        if (this.config().getSslContext() != null) {
            SslPlugin sslPlugin = new SslPlugin(() -> ((ServerConfig)this.config()).getSslContext(), sslEngine -> sslEngine.setUseClientMode(false));
            processor.addPlugin((Plugin)sslPlugin);
        }
        if (this.config().getIdleTimeout() > 0L) {
            processor.addPlugin((Plugin)new IdleStatePlugin((int)this.config().getIdleTimeout(), true, false));
        }
        this.server = this.config().getHost() != null ? new AioQuickServer(this.config().getPort(), (Protocol)this.assistant(), (MessageProcessor)processor) : new AioQuickServer(this.config().getHost(), this.config().getPort(), (Protocol)this.assistant(), (MessageProcessor)processor);
        this.server.setThreadNum(this.config().getCoreThreads());
        this.server.setBannerEnabled(false);
        if (this.config().getReadBufferSize() > 0) {
            this.server.setReadBufferSize(this.config().getReadBufferSize());
        }
        if (this.config().getWriteBufferSize() > 0) {
            this.server.setWriteBuffer(this.config().getWriteBufferSize(), 16);
        }
        this.server.start();
        log.info("Server started: {server=" + this.config().getLocalUrl() + "}");
        return this;
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            log.debug("{}", (Throwable)e);
        }
    }
}

