/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.impl;

import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.TcpAioChannelAssistant;
import org.noear.socketd.transport.smartsocket.TcpAioServer;
import org.noear.socketd.transport.smartsocket.impl.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.transport.AioSession;

public class ServerMessageProcessor
extends AbstractMessageProcessor<Frame> {
    private static final Logger log = LoggerFactory.getLogger(ServerMessageProcessor.class);
    private TcpAioServer server;

    public ServerMessageProcessor(TcpAioServer server) {
        this.server = server;
    }

    private Channel getChannel(AioSession s) {
        return Attachment.getChannel(s, (Config)this.server.config(), (TcpAioChannelAssistant)this.server.assistant());
    }

    public void process0(AioSession s, Frame frame) {
        Channel channel = this.getChannel(s);
        try {
            this.server.processor().onReceive(channel, frame);
        }
        catch (Throwable e) {
            if (channel == null) {
                log.warn(e.getMessage(), e);
            }
            this.server.processor().onError(channel.getSession(), e);
        }
    }

    public void stateEvent0(AioSession s, StateMachineEnum state, Throwable e) {
        switch (state) {
            case NEW_SESSION: {
                break;
            }
            case SESSION_CLOSED: {
                this.server.processor().onClose(this.getChannel(s).getSession());
                break;
            }
            case PROCESS_EXCEPTION: 
            case DECODE_EXCEPTION: 
            case INPUT_EXCEPTION: 
            case ACCEPT_EXCEPTION: 
            case OUTPUT_EXCEPTION: {
                this.server.processor().onError(this.getChannel(s).getSession(), e);
            }
        }
    }
}

