/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.transport.client.ClientBase;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.smartsocket.TcpAioClient;
import org.noear.socketd.transport.smartsocket.impl.ClientMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.extension.plugins.IdleStatePlugin;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.transport.AioQuickClient;

public class TcpAioClientConnector
extends ClientConnectorBase<TcpAioClient> {
    private static final Logger log = LoggerFactory.getLogger(TcpAioClientConnector.class);
    private AioQuickClient real;

    public TcpAioClientConnector(TcpAioClient client) {
        super((ClientBase)client);
    }

    public ChannelInternal connect() throws IOException {
        ClientMessageProcessor messageProcessor = new ClientMessageProcessor((TcpAioClient)this.client);
        try {
            if (((TcpAioClient)this.client).config().getSslContext() != null) {
                SslPlugin sslPlugin = new SslPlugin(() -> ((ClientConfig)((TcpAioClient)this.client).config()).getSslContext(), sslEngine -> sslEngine.setUseClientMode(true));
                messageProcessor.addPlugin((Plugin)sslPlugin);
            }
            if (((TcpAioClient)this.client).config().getIdleTimeout() > 0L) {
                messageProcessor.addPlugin((Plugin)new IdleStatePlugin((int)((TcpAioClient)this.client).config().getIdleTimeout(), true, false));
            }
            this.real = new AioQuickClient(((TcpAioClient)this.client).config().getHost(), ((TcpAioClient)this.client).config().getPort(), (Protocol)((TcpAioClient)this.client).frameProtocol(), (MessageProcessor)messageProcessor);
            if (((TcpAioClient)this.client).config().getReadBufferSize() > 0) {
                this.real.setReadBufferSize(((TcpAioClient)this.client).config().getReadBufferSize());
            }
            if (((TcpAioClient)this.client).config().getWriteBufferSize() > 0) {
                this.real.setWriteBuffer(((TcpAioClient)this.client).config().getWriteBufferSize(), 16);
            }
            if (((TcpAioClient)this.client).config().getConnectTimeout() > 0L) {
                this.real.connectTimeout((int)((TcpAioClient)this.client).config().getConnectTimeout());
            }
            this.real.start();
            ClientHandshakeResult handshakeResult = messageProcessor.getHandshakeFuture().get(((TcpAioClient)this.client).config().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketdConnectionException("Connection timeout: " + ((TcpAioClient)this.client).config().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketdConnectionException(e);
        }
    }

    public void close() {
        block4: {
            if (this.real == null) {
                return;
            }
            try {
                if (this.real != null) {
                    this.real.shutdown();
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Client connector close error", e);
            }
        }
    }
}

