/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket;

import java.io.IOException;
import org.noear.socketd.SocketD;
import org.noear.socketd.exception.SocketdException;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.smartsocket.TcpAioChannelAssistant;
import org.noear.socketd.transport.smartsocket.impl.IdleStatePluginEx;
import org.noear.socketd.transport.smartsocket.impl.ServerMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.transport.AioQuickServer;

public class TcpAioServer
extends ServerBase<TcpAioChannelAssistant> {
    private static final Logger log = LoggerFactory.getLogger(TcpAioServer.class);
    private AioQuickServer server;

    public TcpAioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new TcpAioChannelAssistant((Config)config));
    }

    public String title() {
        return "tcp/aio/smart-socket 1.5/" + SocketD.version();
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        ServerMessageProcessor processor = new ServerMessageProcessor(this);
        try {
            if (this.config().getSslContext() != null) {
                SslPlugin sslPlugin = new SslPlugin(() -> ((ServerConfig)this.config()).getSslContext(), sslEngine -> sslEngine.setUseClientMode(false));
                processor.addPlugin((Plugin)sslPlugin);
            }
            if (this.config().getIdleTimeout() > 0L) {
                processor.addPlugin((Plugin)new IdleStatePluginEx((int)this.config().getIdleTimeout(), true, false));
            }
            this.server = this.config().getHost() != null ? new AioQuickServer(this.config().getPort(), (Protocol)this.assistant(), (MessageProcessor)processor) : new AioQuickServer(this.config().getHost(), this.config().getPort(), (Protocol)this.assistant(), (MessageProcessor)processor);
            this.server.setThreadNum(this.config().getCoreThreads());
            this.server.setBannerEnabled(false);
            if (this.config().getReadBufferSize() > 0) {
                this.server.setReadBufferSize(this.config().getReadBufferSize());
            }
            if (this.config().getWriteBufferSize() > 0) {
                this.server.setWriteBuffer(this.config().getWriteBufferSize(), 16);
            }
            this.server.start();
        }
        catch (Exception e) {
            if (this.server != null) {
                this.server.shutdown();
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketdException((Throwable)e);
        }
        log.info("Socket.D server started: {server=" + this.config().getLocalUrl() + "}");
        return this;
    }

    public void stop() {
        block4: {
            if (!this.isStarted) {
                return;
            }
            this.isStarted = false;
            try {
                if (this.server != null) {
                    this.server.shutdown();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Server stop error", (Throwable)e);
            }
        }
    }
}

