/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.tcp;

import java.io.IOException;
import org.noear.socketd.SocketD;
import org.noear.socketd.exception.SocketDException;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.transport.smartsocket.tcp.TcpAioChannelAssistant;
import org.noear.socketd.transport.smartsocket.tcp.impl.FrameProtocol;
import org.noear.socketd.transport.smartsocket.tcp.impl.IdleStatePluginEx;
import org.noear.socketd.transport.smartsocket.tcp.impl.ServerMessageProcessor;
import org.noear.socketd.utils.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.transport.AioQuickServer;
import org.smartboot.socket.transport.AioSession;

public class TcpAioServer
extends ServerBase<TcpAioChannelAssistant>
implements ChannelSupporter<AioSession> {
    private static final Logger log = LoggerFactory.getLogger(TcpAioServer.class);
    private AioQuickServer server;
    private final FrameProtocol frameProtocol = new FrameProtocol(this);

    public TcpAioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new TcpAioChannelAssistant((Config)config));
    }

    public String getTitle() {
        return "tcp/aio/smart-socket 1.5/" + SocketD.version();
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        ServerMessageProcessor messageProcessor = new ServerMessageProcessor(this);
        try {
            if (this.getConfig().getSslContext() != null) {
                SslPlugin sslPlugin = new SslPlugin(() -> ((ServerConfig)this.getConfig()).getSslContext(), sslEngine -> sslEngine.setUseClientMode(false));
                messageProcessor.addPlugin((Plugin)sslPlugin);
            }
            if (this.getConfig().getIdleTimeout() > 0L) {
                messageProcessor.addPlugin((Plugin)new IdleStatePluginEx((int)this.getConfig().getIdleTimeout(), true, false));
            }
            this.server = StrUtils.isEmpty((String)this.getConfig().getHost()) ? new AioQuickServer(this.getConfig().getPort(), (Protocol)this.frameProtocol, (MessageProcessor)messageProcessor) : new AioQuickServer(this.getConfig().getHost(), this.getConfig().getPort(), (Protocol)this.frameProtocol, (MessageProcessor)messageProcessor);
            this.server.setThreadNum(Math.max(this.getConfig().getCodecThreads(), 2));
            this.server.setBannerEnabled(false);
            if (this.getConfig().getReadBufferSize() > 0) {
                this.server.setReadBufferSize(this.getConfig().getReadBufferSize());
            }
            if (this.getConfig().getWriteBufferSize() > 0) {
                this.server.setWriteBuffer(this.getConfig().getWriteBufferSize(), 16);
            }
            this.server.start();
        }
        catch (Exception e) {
            if (this.server != null) {
                this.server.shutdown();
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketDException("Socket.D server start failed!", (Throwable)e);
        }
        log.info("Socket.D server started: {server=" + this.getConfig().getLocalUrl() + "}");
        return this;
    }

    public void stop() {
        block4: {
            if (!this.isStarted) {
                return;
            }
            this.isStarted = false;
            super.stop();
            try {
                if (this.server != null) {
                    this.server.shutdown();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Server stop error", (Throwable)e);
            }
        }
    }
}

