/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.tcp.impl;

import java.util.concurrent.CompletableFuture;
import org.noear.socketd.exception.SocketDConnectionException;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.tcp.TcpAioClient;
import org.noear.socketd.transport.smartsocket.tcp.impl.ChannelDefaultEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.transport.AioSession;

public class ClientMessageProcessor
extends AbstractMessageProcessor<Frame> {
    private static final Logger log = LoggerFactory.getLogger(ClientMessageProcessor.class);
    private TcpAioClient client;
    private CompletableFuture<ClientHandshakeResult> handshakeFuture = new CompletableFuture();

    public ClientMessageProcessor(TcpAioClient client) {
        this.client = client;
    }

    public CompletableFuture<ClientHandshakeResult> getHandshakeFuture() {
        return this.handshakeFuture;
    }

    private ChannelDefaultEx getChannel(AioSession s) {
        return ChannelDefaultEx.get(s, this.client);
    }

    public void process0(AioSession s, Frame frame) {
        ChannelDefaultEx channel = this.getChannel(s);
        try {
            if (frame.flag() == 11) {
                channel.onOpenFuture((arg_0, arg_1) -> this.lambda$process0$0((ChannelInternal)channel, arg_0, arg_1));
            }
            this.client.getProcessor().onReceive((ChannelInternal)channel, frame);
        }
        catch (Exception e) {
            if (e instanceof SocketDConnectionException) {
                this.handshakeFuture.complete(new ClientHandshakeResult((ChannelInternal)channel, (Throwable)e));
                return;
            }
            if (channel == null) {
                log.warn("Client process0 error", (Throwable)e);
            }
            this.client.getProcessor().onError((ChannelInternal)channel, (Throwable)e);
        }
    }

    public void stateEvent0(AioSession s, StateMachineEnum state, Throwable e) {
        switch (state) {
            case NEW_SESSION: {
                ChannelDefaultEx channel = this.getChannel(s);
                try {
                    channel.sendConnect(this.client.getConfig().getUrl(), this.client.getConfig().getMetaMap());
                }
                catch (Throwable ex) {
                    this.client.getProcessor().onError((ChannelInternal)channel, ex);
                }
                break;
            }
            case SESSION_CLOSED: {
                this.client.getProcessor().onClose((ChannelInternal)this.getChannel(s));
                break;
            }
            case PROCESS_EXCEPTION: 
            case DECODE_EXCEPTION: 
            case INPUT_EXCEPTION: 
            case ACCEPT_EXCEPTION: 
            case OUTPUT_EXCEPTION: {
                this.client.getProcessor().onError((ChannelInternal)this.getChannel(s), e);
            }
        }
    }

    private /* synthetic */ void lambda$process0$0(ChannelInternal channel, Boolean r, Throwable e) {
        this.handshakeFuture.complete(new ClientHandshakeResult(channel, e));
    }
}

