/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.tcp;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.noear.socketd.exception.SocketDConnectionException;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.smartsocket.tcp.TcpAioClient;
import org.noear.socketd.transport.smartsocket.tcp.impl.ClientMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.extension.plugins.IdleStatePlugin;
import org.smartboot.socket.extension.plugins.Plugin;
import org.smartboot.socket.extension.plugins.SslPlugin;
import org.smartboot.socket.transport.AioQuickClient;

public class TcpAioClientConnector
extends ClientConnectorBase<TcpAioClient> {
    private static final Logger log = LoggerFactory.getLogger(TcpAioClientConnector.class);
    private AioQuickClient real;
    private Thread connectThread;

    public TcpAioClientConnector(TcpAioClient client) {
        super((ClientInternal)client);
    }

    public ChannelInternal connect() throws IOException {
        this.close();
        ClientMessageProcessor messageProcessor = new ClientMessageProcessor((TcpAioClient)this.client);
        this.connectThread = new Thread(() -> {
            try {
                this.connectDo(messageProcessor);
            }
            catch (Throwable e) {
                messageProcessor.getHandshakeFuture().complete(new ClientHandshakeResult(null, e));
            }
        });
        this.connectThread.start();
        try {
            ClientHandshakeResult handshakeResult = messageProcessor.getHandshakeFuture().get(((TcpAioClient)this.client).getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketDConnectionException("Connection timeout: " + ((TcpAioClient)this.client).getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketDConnectionException("Connection failed: " + ((TcpAioClient)this.client).getConfig().getLinkUrl(), e);
        }
    }

    private void connectDo(ClientMessageProcessor messageProcessor) throws Exception {
        if (((TcpAioClient)this.client).getConfig().getSslContext() != null) {
            SslPlugin sslPlugin = new SslPlugin(() -> ((ClientConfig)((TcpAioClient)this.client).getConfig()).getSslContext(), sslEngine -> sslEngine.setUseClientMode(true));
            messageProcessor.addPlugin((Plugin)sslPlugin);
        }
        if (((TcpAioClient)this.client).getConfig().getIdleTimeout() > 0L) {
            messageProcessor.addPlugin((Plugin)new IdleStatePlugin((int)((TcpAioClient)this.client).getConfig().getIdleTimeout(), true, false));
        }
        this.real = new AioQuickClient(((TcpAioClient)this.client).getConfig().getHost(), ((TcpAioClient)this.client).getConfig().getPort(), (Protocol)((TcpAioClient)this.client).frameProtocol(), (MessageProcessor)messageProcessor);
        if (((TcpAioClient)this.client).getConfig().getReadBufferSize() > 0) {
            this.real.setReadBufferSize(((TcpAioClient)this.client).getConfig().getReadBufferSize());
        }
        if (((TcpAioClient)this.client).getConfig().getWriteBufferSize() > 0) {
            this.real.setWriteBuffer(((TcpAioClient)this.client).getConfig().getWriteBufferSize(), 16);
        }
        if (((TcpAioClient)this.client).getConfig().getConnectTimeout() > 0L) {
            this.real.connectTimeout((int)((TcpAioClient)this.client).getConfig().getConnectTimeout());
        }
        this.real.start();
    }

    public void close() {
        block4: {
            try {
                if (this.real != null) {
                    this.real.shutdown();
                }
                if (this.connectThread != null) {
                    this.connectThread.interrupt();
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Client connector close error", e);
            }
        }
    }
}

