/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.tcp.impl;

import java.util.concurrent.CompletableFuture;
import org.noear.socketd.exception.SocketDConnectionException;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.tcp.TcpAioClient;
import org.noear.socketd.transport.smartsocket.tcp.impl.ChannelDefaultEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.extension.processor.AbstractMessageProcessor;
import org.smartboot.socket.transport.AioSession;

public class ClientMessageProcessor
extends AbstractMessageProcessor<Frame> {
    private static final Logger log = LoggerFactory.getLogger(ClientMessageProcessor.class);
    private TcpAioClient client;
    private CompletableFuture<ClientHandshakeResult> handshakeFuture = new CompletableFuture();

    public ClientMessageProcessor(TcpAioClient client) {
        this.client = client;
    }

    public CompletableFuture<ClientHandshakeResult> getHandshakeFuture() {
        return this.handshakeFuture;
    }

    public void process0(AioSession s, Frame frame) {
        ChannelInternal channel = (ChannelInternal)s.getAttachment();
        try {
            if (frame.flag() == 11) {
                channel.onOpenFuture((r, e) -> this.handshakeFuture.complete(new ClientHandshakeResult(channel, e)));
            }
            this.client.getProcessor().onReceive(channel, frame);
        }
        catch (Exception e2) {
            if (e2 instanceof SocketDConnectionException) {
                this.handshakeFuture.complete(new ClientHandshakeResult(channel, (Throwable)e2));
                return;
            }
            if (channel == null) {
                log.warn("Client process0 error", (Throwable)e2);
            }
            this.client.getProcessor().onError(channel, (Throwable)e2);
        }
    }

    public void stateEvent0(AioSession s, StateMachineEnum state, Throwable e) {
        switch (state) {
            case NEW_SESSION: {
                ChannelDefaultEx<AioSession> c = new ChannelDefaultEx<AioSession>(s, this.client);
                s.setAttachment(c);
                try {
                    c.sendConnect(this.client.getConfig().getUrl(), this.client.getConfig().getMetaMap());
                }
                catch (Throwable ex) {
                    this.client.getProcessor().onError(c, ex);
                }
                break;
            }
            case SESSION_CLOSED: {
                ChannelDefaultEx c = (ChannelDefaultEx)((Object)s.getAttachment());
                this.client.getProcessor().onClose((ChannelInternal)c);
                break;
            }
            case PROCESS_EXCEPTION: 
            case DECODE_EXCEPTION: 
            case INPUT_EXCEPTION: 
            case ACCEPT_EXCEPTION: 
            case OUTPUT_EXCEPTION: {
                ChannelDefaultEx c = (ChannelDefaultEx)((Object)s.getAttachment());
                if (c == null) break;
                this.client.getProcessor().onError((ChannelInternal)c, e);
                break;
            }
        }
    }
}

