/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.smartsocket.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.smartsocket.tcp.TcpAioBufferWriter;
import org.noear.socketd.utils.IoCompletionHandler;
import org.smartboot.socket.transport.AioSession;

public class TcpAioChannelAssistant
implements ChannelAssistant<AioSession> {
    private final Config config;

    public TcpAioChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(AioSession source, Frame frame, ChannelInternal channel, IoCompletionHandler completionHandler) {
        try {
            this.config.getCodec().write(frame, i -> new TcpAioBufferWriter(source.writeBuffer()));
            completionHandler.completed(true, null);
        }
        catch (Throwable e) {
            completionHandler.completed(false, e);
        }
    }

    public boolean isValid(AioSession target) {
        return !target.isInvalid();
    }

    public void close(AioSession target) throws IOException {
        block3: {
            if (!target.isInvalid()) {
                try {
                    target.close();
                }
                catch (Throwable e) {
                    if (e instanceof ClosedChannelException) break block3;
                    throw e;
                }
            }
        }
    }

    public InetSocketAddress getRemoteAddress(AioSession target) throws IOException {
        return target.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress(AioSession target) throws IOException {
        return target.getLocalAddress();
    }
}

