/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.client.registration;

import java.util.Timer;
import java.util.TimerTask;
import org.noear.solon.admin.client.config.AdminClientBootstrapConfiguration;
import org.noear.solon.admin.client.config.IClientProperties;
import org.noear.solon.admin.client.services.ApplicationRegistrationService;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.event.AppPrestopEndEvent;
import org.noear.solon.core.event.EventBus;

@Configuration
public class AutoRegistrationConfiguration {
    private final Timer timer = new Timer();
    @Inject
    private IClientProperties clientProperties;

    @Bean
    public void afterInjection(@Inject(required=false) AdminClientBootstrapConfiguration.MarkedClientEnabled marked, @Inject ApplicationRegistrationService applicationRegistrationService) {
        if (marked == null) {
            return;
        }
        EventBus.subscribe(AppLoadEndEvent.class, e -> this.onStart(applicationRegistrationService));
        EventBus.subscribe(AppPrestopEndEvent.class, e -> this.onStop(applicationRegistrationService));
    }

    public void onStart(final ApplicationRegistrationService applicationRegistrationService) {
        applicationRegistrationService.register();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                applicationRegistrationService.heartbeat();
            }
        }, 0L, this.clientProperties.getHeartbeatInterval());
    }

    public void onStop(ApplicationRegistrationService applicationRegistrationService) {
        this.timer.cancel();
    }
}

