/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.client.config;

import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.noear.solon.Solon;
import org.noear.solon.admin.client.config.CloudClientProperties;
import org.noear.solon.admin.client.config.IClientProperties;
import org.noear.solon.admin.client.config.LocalClientProperties;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration
public class AdminClientBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AdminClientBootstrapConfiguration.class);

    @Condition(onProperty="${solon.admin.client.mode:local} = local")
    @Bean
    public IClientProperties localClientProperties(@Inject(value="${solon.admin.client}") LocalClientProperties properties) {
        log.debug("Injected localClientProperties: " + properties);
        return properties;
    }

    @Condition(onProperty="${solon.admin.client.mode:local} = cloud")
    @Bean
    public IClientProperties cloudClientProperties(@Inject(value="${solon.admin.client}") CloudClientProperties properties) {
        log.debug("Injected cloudClientProperties: " + properties);
        return properties;
    }

    @Bean
    public MarkedClientEnabled markedClientEnabled(@Inject(required=false) IClientProperties clientProperties) {
        if (clientProperties == null || !clientProperties.isEnabled()) {
            log.error("Failed to enable Solon Admin client.", (Throwable)new IllegalStateException("Could not enable Solon Admin client because none of the properties has been configured correctly."));
            return null;
        }
        return new MarkedClientEnabled(clientProperties.getMode());
    }

    @Bean
    public OkHttpClient okHttpClient(@Inject(required=false) MarkedClientEnabled marker) {
        if (marker == null) {
            return null;
        }
        IClientProperties config = (IClientProperties)Solon.context().getBean(IClientProperties.class);
        return new OkHttpClient.Builder().connectTimeout(config.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(config.getReadTimeout(), TimeUnit.MILLISECONDS).build();
    }

    public static final class MarkedClientEnabled {
        private final String mode;

        public MarkedClientEnabled(String mode) {
            this.mode = mode;
            log.info("Solon Admin client has been successfully enabled in {} mode.", (Object)this.mode);
        }

        public String getMode() {
            return this.mode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarkedClientEnabled)) {
                return false;
            }
            MarkedClientEnabled other = (MarkedClientEnabled)o;
            String this$mode = this.getMode();
            String other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            return result;
        }

        public String toString() {
            return "AdminClientBootstrapConfiguration.MarkedClientEnabled(mode=" + this.getMode() + ")";
        }
    }
}

