/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.client.services;

import java.net.URL;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.noear.solon.Solon;
import org.noear.solon.admin.client.config.ClientProperties;
import org.noear.solon.admin.client.data.Application;
import org.noear.solon.admin.client.data.EnvironmentInformation;
import org.noear.solon.admin.client.utils.JsonUtils;
import org.noear.solon.admin.client.utils.NetworkUtils;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ApplicationRegistrationService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRegistrationService.class);
    @Inject
    private OkHttpClient client;
    @Inject(value="${solon.app.name}")
    private String applicationName;
    @Inject
    private ClientProperties properties;

    private Application.ApplicationBuilder getApplicationBuilder() {
        return Application.builder().name(this.applicationName).token(this.properties.getToken()).baseUrl(NetworkUtils.getHostAndPort());
    }

    public Application getCurrentApplication() {
        return this.getApplicationBuilder().build();
    }

    public void register() {
        log.info("Attempting to register this client as an application with Solon Admin server...");
        String serverUrl = this.properties.getServerUrl().replaceAll("/+$", "");
        String clientMetadata = Solon.cfg().getProp("solon.app").toString();
        try (Response response = this.client.newCall(new Request.Builder().url(new URL(serverUrl + "/solon-admin/api/application/register")).put(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JsonUtils.toJson(this.getApplicationBuilder().metadata(clientMetadata).showSecretInformation(this.properties.isShowSecretInformation()).environmentInformation(EnvironmentInformation.create()).build()))).build()).execute();){
            if (response.isSuccessful()) {
                log.info("Successfully register application to Solon Admin server.");
                return;
            }
            log.error("Failed to register application to Solon Admin server. Response: {}", (Object)response);
        }
        catch (Exception ex) {
            log.error("Unexpected error occurred during the application registration:", (Throwable)ex);
        }
    }

    public void unregister() {
        log.info("Attempting to unregister this client from Solon Admin server...");
        String serverUrl = this.properties.getServerUrl().replaceAll("/+$", "");
        try (Response response = this.client.newCall(new Request.Builder().url(new URL(serverUrl + "/solon-admin/api/application/unregister")).delete(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JsonUtils.toJson(this.getCurrentApplication()))).build()).execute();){
            if (response.isSuccessful()) {
                log.info("Successfully unregister application from Solon Admin server.");
                return;
            }
            log.error("Failed to unregister application to Solon Admin server. Response: {}", (Object)response);
        }
        catch (Exception ex) {
            log.error("Unexpected error occurred during the application de-registration:", (Throwable)ex);
        }
    }

    public void heartbeat() {
        log.trace("Attempting to send heartbeat to Solon Admin server...");
        String serverUrl = this.properties.getServerUrl().replaceAll("/+$", "");
        try (Response response = this.client.newCall(new Request.Builder().url(new URL(serverUrl + "/solon-admin/api/application/heartbeat")).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JsonUtils.toJson(this.getCurrentApplication()))).build()).execute();){
            if (response.isSuccessful()) {
                log.trace("Successfully send heartbeat to Solon Admin server.");
                return;
            }
            log.error("Failed to send heartbeat to Solon Admin server. Response: {}", (Object)response);
        }
        catch (Exception ex) {
            log.error("Unexpected error occurred during the heartbeat sending:", (Throwable)ex);
        }
    }
}

