/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.client.config;

import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.admin.client.config.ClientProperties;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configuration
public class AdminClientBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AdminClientBootstrapConfiguration.class);
    @Inject
    AppContext appContext;
    @Inject(value="${solon.admin.client}", required=false)
    ClientProperties clientProperties = new ClientProperties();

    @Bean
    public ClientProperties clientProperties() {
        if ("local".equals(this.clientProperties.getMode())) {
            log.debug("Injected localClientProperties: " + this.clientProperties);
        } else {
            log.debug("Injected cloudClientProperties: " + this.clientProperties);
        }
        String serverUrl = (String)Solon.app().shared().get("solon-admin-server-url");
        if (Utils.isNotEmpty((String)serverUrl)) {
            this.clientProperties.setServerUrl(serverUrl);
        }
        return this.clientProperties;
    }

    @Bean
    public MarkedClientEnabled markedClientEnabled(@Inject ClientProperties clientProperties) {
        if (clientProperties == null || !clientProperties.isEnabled()) {
            return null;
        }
        return new MarkedClientEnabled(clientProperties.getMode());
    }

    @Bean
    public OkHttpClient okHttpClient(@Inject(required=false) MarkedClientEnabled marker, @Inject ClientProperties clientProperties) {
        if (marker == null) {
            return null;
        }
        return new OkHttpClient.Builder().connectTimeout(clientProperties.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(clientProperties.getReadTimeout(), TimeUnit.MILLISECONDS).build();
    }

    public static final class MarkedClientEnabled {
        private final String mode;

        public MarkedClientEnabled(String mode) {
            this.mode = mode;
            log.info("Solon Admin client has been successfully enabled in {} mode.", (Object)this.mode);
        }

        public String getMode() {
            return this.mode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarkedClientEnabled)) {
                return false;
            }
            MarkedClientEnabled other = (MarkedClientEnabled)o;
            String this$mode = this.getMode();
            String other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            return result;
        }

        public String toString() {
            return "AdminClientBootstrapConfiguration.MarkedClientEnabled(mode=" + this.getMode() + ")";
        }
    }
}

