/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.client.services;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.noear.snack.ONode;
import org.noear.solon.Solon;
import org.noear.solon.admin.client.config.ClientProperties;
import org.noear.solon.admin.client.data.Application;
import org.noear.solon.admin.client.data.EnvironmentInformation;
import org.noear.solon.admin.client.utils.JsonUtils;
import org.noear.solon.admin.client.utils.NetworkUtils;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.handle.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ApplicationRegistrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationRegistrationService.class);
    @Inject
    private OkHttpClient client;
    @Inject(value="${solon.app.name}")
    private String applicationName;
    @Inject
    private ClientProperties properties;

    private Application.ApplicationBuilder getApplicationBuilder() {
        return Application.builder().name(this.applicationName).token(this.properties.getToken()).baseUrl(NetworkUtils.getHostAndPort());
    }

    public Application getCurrentApplication() {
        return this.getApplicationBuilder().build();
    }

    public void register() {
        log.info("Attempting to register this client as an application with Solon Admin server...");
        boolean registerResult = false;
        while (!registerResult) {
            String serverUrl = this.getServerUrl();
            if (serverUrl != null) {
                String clientMetadata = Solon.cfg().getProp("solon.app").toString();
                try (Response response = this.client.newCall(new Request.Builder().url(new URL(serverUrl + "/solon-admin/api/application/register")).put(RequestBody.create((String)JsonUtils.toJson(this.getApplicationBuilder().metadata(clientMetadata).showSecretInformation(this.properties.isShowSecretInformation()).environmentInformation(EnvironmentInformation.create()).build()), (MediaType)MediaType.parse((String)"application/json"))).build()).execute();){
                    registerResult = this.assertResponse("register application", response, false);
                }
                catch (Exception ex) {
                    log.warn("Unexpected error occurred during the application registration: {}", (Object)ex.getMessage());
                    registerResult = false;
                }
            }
            try {
                Thread.sleep(this.properties.getRetryInterval());
            }
            catch (InterruptedException ex) {
                log.warn(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void unregister() {
        log.info("Attempting to unregister this client from Solon Admin server...");
        String serverUrl = this.getServerUrl();
        if (serverUrl != null) {
            try (Response response = this.client.newCall(new Request.Builder().url(new URL(serverUrl + "/solon-admin/api/application/unregister")).delete(RequestBody.create((String)JsonUtils.toJson(this.getCurrentApplication()), (MediaType)MediaType.parse((String)"application/json"))).build()).execute();){
                this.assertResponse("unregister application", response, false);
            }
            catch (Exception ex) {
                log.warn("Unexpected error occurred during the application de-registration: {}", (Object)ex.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean heartbeat() {
        log.trace("Attempting to send heartbeat to Solon Admin server...");
        String serverUrl = this.getServerUrl();
        if (serverUrl == null) return false;
        try (Response response = this.client.newCall(new Request.Builder().url(new URL(serverUrl + "/solon-admin/api/application/heartbeat")).post(RequestBody.create((String)JsonUtils.toJson(this.getCurrentApplication()), (MediaType)MediaType.parse((String)"application/json"))).build()).execute();){
            boolean bl = this.assertResponse("send heartbeat", response, true);
            return bl;
        }
        catch (Exception ex) {
            log.warn("Unexpected error occurred during the heartbeat sending: {}", (Object)ex.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getServerUrl() {
        String serverUrl;
        URI serverUri = URI.create(this.properties.getServerUrl());
        if ("cloud".equals(this.properties.getMode()) && serverUri.getScheme().equals("lb")) {
            String server = LoadBalance.get((String)Solon.cfg().appGroup(), (String)serverUri.getHost()).getServer();
            if (server != null) {
                serverUrl = server;
                return serverUrl.replaceAll("/+$", "");
            }
            log.warn("Not found Solon Admin server instance: {}:{}", (Object)Solon.cfg().appGroup(), (Object)serverUri.getHost());
            return null;
        }
        serverUrl = serverUri.toString();
        return serverUrl.replaceAll("/+$", "");
    }

    private boolean assertResponse(String type, Response response, boolean traceLog) throws IOException {
        ResponseBody body;
        if (!response.isSuccessful()) {
            log.error("Failed to {} to Solon Admin server. response: {}", (Object)type, (Object)response);
        }
        if ((body = response.body()) != null) {
            String res = new String(response.body().bytes());
            Result result = (Result)ONode.load((Object)res).toObject(Result.class);
            if (result.getCode() == 200) {
                if (traceLog) {
                    log.trace("Successfully {} to Solon Admin server.", (Object)type);
                } else {
                    log.info("Successfully {} to Solon Admin server.", (Object)type);
                }
                return true;
            }
            log.error("Failed to {} to Solon Admin server. adminResponse: {}", (Object)type, (Object)res);
            return false;
        }
        log.error("Failed to {} to Solon Admin server. adminResponse: null", (Object)type);
        return false;
    }
}

