/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.client.data;

import java.util.Objects;
import org.noear.solon.admin.client.data.EnvironmentInformation;

public class Application {
    private final String name;
    private final String token;
    private String baseUrl;
    private final String metadata;
    private final boolean showSecretInformation;
    private final EnvironmentInformation environmentInformation;

    private Application(String name, String token, String baseUrl, String metadata, boolean showSecretInformation, EnvironmentInformation environmentInformation) {
        this.name = name;
        this.token = token;
        this.baseUrl = baseUrl;
        this.metadata = metadata;
        this.showSecretInformation = showSecretInformation;
        this.environmentInformation = environmentInformation;
    }

    public static ApplicationBuilder builder() {
        return new ApplicationBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getToken() {
        return this.token;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public boolean isShowSecretInformation() {
        return this.showSecretInformation;
    }

    public EnvironmentInformation getEnvironmentInformation() {
        return this.environmentInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application that = (Application)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.token, that.token) && Objects.equals(this.baseUrl, that.baseUrl);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.token, this.baseUrl);
    }

    public String toString() {
        return "Application{name='" + this.name + '\'' + ", token='" + this.token + '\'' + ", baseUrl='" + this.baseUrl + '\'' + '}';
    }

    public static class ApplicationBuilder {
        private String name;
        private String token;
        private String baseUrl;
        private String metadata;
        private boolean showSecretInformation;
        private EnvironmentInformation environmentInformation;

        ApplicationBuilder() {
        }

        public ApplicationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ApplicationBuilder token(String token) {
            this.token = token;
            return this;
        }

        public ApplicationBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ApplicationBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public ApplicationBuilder showSecretInformation(boolean showSecretInformation) {
            this.showSecretInformation = showSecretInformation;
            return this;
        }

        public ApplicationBuilder environmentInformation(EnvironmentInformation environmentInformation) {
            this.environmentInformation = environmentInformation;
            return this;
        }

        public Application build() {
            return new Application(this.name, this.token, this.baseUrl, this.metadata, this.showSecretInformation, this.environmentInformation);
        }
    }
}

