/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.client.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.noear.solon.Solon;

public final class EnvironmentInformation {
    private final Map<String, String> systemEnvironment;
    private final Map<String, String> systemProperties;
    private final Map<String, String> applicationProperties;

    public EnvironmentInformation(Map<String, String> systemEnvironment, Map<String, String> systemProperties, Map<String, String> applicationProperties) {
        this.systemEnvironment = systemEnvironment;
        this.systemProperties = systemProperties;
        this.applicationProperties = applicationProperties;
    }

    public static EnvironmentInformation create() {
        return EnvironmentInformation.create(Solon.cfg().getBool("solon.admin.client.showSecretInformation", false));
    }

    public static EnvironmentInformation create(boolean showSecretInformation) {
        HashMap<String, String> systemEnvironment = new HashMap<String, String>();
        HashMap<String, String> systemProperties = new HashMap<String, String>();
        HashMap<String, String> applicationProperties = new HashMap<String, String>();
        System.getenv().forEach((key, value) -> systemEnvironment.put((String)key, showSecretInformation ? value : "******"));
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> systemProperties.put(key.toString(), showSecretInformation ? value.toString() : "******")));
        Solon.cfg().forEach((key, value) -> applicationProperties.put(key.toString(), showSecretInformation ? value.toString() : "******"));
        return new EnvironmentInformation(systemEnvironment, systemProperties, applicationProperties);
    }

    public Map<String, String> getSystemEnvironment() {
        return this.systemEnvironment;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getApplicationProperties() {
        return this.applicationProperties;
    }
}

