/*
 * Decompiled with CFR 0.152.
 */
package io.a2a_preview.client;

import io.a2a_preview.client.A2AClient;
import io.a2a_preview.client.HostAgentAssistantTools;
import io.a2a_preview.model.AgentCard;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.ai.chat.ChatModel;
import org.noear.solon.ai.chat.ChatResponse;
import org.noear.solon.ai.chat.ChatSession;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.message.SystemMessage;
import org.noear.solon.ai.chat.prompt.ChatPrompt;
import org.noear.solon.ai.chat.tool.MethodToolProvider;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.reactivestreams.Publisher;

public class HostAgent {
    private ChatModel chatModel = null;
    private final ToolProvider agentTools;
    private final List<AgentCard> agentCards = new ArrayList<AgentCard>();
    private final List<Map<String, String>> agentInfo = new ArrayList<Map<String, String>>();
    public final Map<String, A2AClient> a2AClientMap = new HashMap<String, A2AClient>();

    public HostAgent() {
        this.agentTools = new MethodToolProvider((Object)new HostAgentAssistantTools(this));
    }

    public List<Map<String, String>> getAgentInfo() {
        return this.agentInfo;
    }

    public List<AgentCard> getAgentCards() {
        return this.agentCards;
    }

    public Map<String, A2AClient> getA2AClientMap() {
        return this.a2AClientMap;
    }

    public void addChatModel(ChatModel chatModel) {
        this.chatModel = chatModel;
    }

    public void register(String remoteAddress) {
        if (remoteAddress.isEmpty()) {
            System.err.println("No remote address provided. Skipping agent registration.");
            return;
        }
        final AgentCard agentCard = new A2AClient(remoteAddress).getAgentCard();
        this.agentCards.add(agentCard);
        this.a2AClientMap.put(agentCard.getName(), new A2AClient(remoteAddress));
        this.agentInfo.add((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("agentName", agentCard.getName());
                this.put("description", agentCard.getDescription());
            }
        });
    }

    public ChatResponse chatCall(String prompt) throws IOException {
        return this.chatModel.prompt(new ChatMessage[]{this.buildSystemMessage(), ChatMessage.ofUser((String)prompt)}).options(o -> o.toolsAdd(this.agentTools)).call();
    }

    public ChatResponse chatCall(ChatSession session) throws IOException {
        session.addMessage(new ChatMessage[]{this.buildSystemMessage()});
        return this.chatModel.prompt((ChatPrompt)session).options(o -> o.toolsAdd(this.agentTools)).call();
    }

    public Publisher<ChatResponse> chatStream(String prompt) {
        return this.chatModel.prompt(new ChatMessage[]{this.buildSystemMessage(), ChatMessage.ofUser((String)prompt)}).options(o -> o.toolsAdd(this.agentTools)).stream();
    }

    public Publisher<ChatResponse> chatStream(ChatSession session) {
        session.addMessage(new ChatMessage[]{this.buildSystemMessage()});
        return this.chatModel.prompt((ChatPrompt)session).options(o -> o.toolsAdd(this.agentTools)).stream();
    }

    private SystemMessage buildSystemMessage() {
        StringBuilder systemPrompt = new StringBuilder("\u60a8\u662f\u4e00\u4f4d\u64c5\u957f\u5206\u914d\u4efb\u52a1\u7684\u4e13\u5bb6\uff0c\u8d1f\u8d23\u5c06\u7528\u6237\u8bf7\u6c42\u5206\u89e3\u4e3a\u5b50\u4ee3\u7406\u53ef\u4ee5\u6267\u884c\u7684\u4efb\u52a1\u3002\u80fd\u591f\u5c06\u7528\u6237\u8bf7\u6c42\u5206\u914d\u7ed9\u5408\u9002\u7684\u8fdc\u7a0b\u4ee3\u7406\u3002\n\n\u53d1\u73b0\uff1a\n- \u4f60\u53ef\u4ee5\u4f7f\u7528\u5de5\u5177 `list_remote_agents` \u5217\u51fa\u53ef\u7528\u4e8e\u5206\u914d\u4efb\u52a1\u7684\u8fdc\u7a0b\u4ee3\u7406\u3002\n\n\u6267\u884c\uff1a\n- \u5bf9\u4e8e\u53ef\u64cd\u4f5c\u7684\u8bf7\u6c42\uff0c\u60a8\u53ef\u4ee5\u4f7f\u7528\u5de5\u5177 `send_message` \u4e0e\u8fdc\u7a0b\u4ee3\u7406\u4ea4\u4e92\u4ee5\u83b7\u53d6\u7ed3\u679c\u3002\n \n\u8bf7\u5728\u56de\u590d\u7528\u6237\u65f6\u5305\u542b\u8fdc\u7a0b\u4ee3\u7406\u7684\u540d\u79f0\u3002\n\n\u8bf7\u4f9d\u9760\u5de5\u5177\u6765\u5904\u7406\u8bf7\u6c42\uff0c\u4e0d\u8981\u7f16\u9020\u56de\u590d\u3002\u5982\u679c\u60a8\u4e0d\u786e\u5b9a\uff0c\u8bf7\u5411\u7528\u6237\u8be2\u95ee\u66f4\u591a\u7ec6\u8282\u3002\n\u4e3b\u8981\u5173\u6ce8\u5bf9\u8bdd\u7684\u6700\u65b0\u90e8\u5206\u3002\u5c06\u5b50\u4efb\u52a1\u7684\u7b54\u6848\u4ee3\u5165\u56de\u7b54\u6bcf\u4e2a\u5b50\u4efb\u52a1\u7684\u7ed3\u679c\u3002\n\n\u4ee3\u7406:\n");
        for (Map<String, String> item : this.agentInfo) {
            systemPrompt.append(item).append("\n");
        }
        return ChatMessage.ofSystem((String)systemPrompt.toString());
    }
}

