/*
 * Decompiled with CFR 0.152.
 */
package io.a2a_preview.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.a2a_preview.model.AgentCard;
import io.a2a_preview.model.ErrorCode;
import io.a2a_preview.model.JSONRPCError;
import io.a2a_preview.model.JSONRPCRequest;
import io.a2a_preview.model.JSONRPCResponse;
import io.a2a_preview.model.Message;
import io.a2a_preview.model.Task;
import io.a2a_preview.model.TaskIDParams;
import io.a2a_preview.model.TaskQueryParams;
import io.a2a_preview.model.TaskSendParams;
import io.a2a_preview.model.TaskState;
import io.a2a_preview.model.TaskStatus;
import io.a2a_preview.server.TaskHandler;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class A2AServer {
    private final AgentCard agentCard;
    private final TaskHandler handler;
    private final Map<String, Task> taskStore;
    private final Map<String, List<Message>> taskHistory;
    private final ObjectMapper objectMapper;

    public A2AServer(AgentCard agentCard, TaskHandler handler) {
        this.agentCard = agentCard;
        this.handler = handler;
        this.taskStore = new ConcurrentHashMap<String, Task>();
        this.taskHistory = new ConcurrentHashMap<String, List<Message>>();
        this.objectMapper = new ObjectMapper();
    }

    public JSONRPCResponse handleTaskSend(JSONRPCRequest request) {
        try {
            TaskSendParams params = this.parseParams(request.getParams(), TaskSendParams.class);
            String contextId = UUID.randomUUID().toString();
            TaskStatus initialStatus = new TaskStatus(TaskState.WORKING, null, Instant.now().toString());
            Task task = new Task(params.getId(), contextId, "task", initialStatus, null, null, params.getMetadata());
            Task updatedTask = this.handler.handle(task, params.getMessage());
            this.taskStore.put(task.getId(), updatedTask);
            this.taskHistory.computeIfAbsent(task.getId(), k -> new CopyOnWriteArrayList()).add(params.getMessage());
            return this.createSuccessResponse(request.getId(), updatedTask);
        }
        catch (Exception e) {
            return this.createErrorResponse(request.getId(), ErrorCode.INTERNAL_ERROR, e.getMessage());
        }
    }

    public JSONRPCResponse handleTaskGet(JSONRPCRequest request) {
        try {
            TaskQueryParams params = this.parseParams(request.getParams(), TaskQueryParams.class);
            Task task = this.taskStore.get(params.getId());
            if (task == null) {
                return this.createErrorResponse(request.getId(), ErrorCode.TASK_NOT_FOUND, "Task not found");
            }
            if (params.getHistoryLength() != null && params.getHistoryLength() > 0) {
                List<Message> history = this.getTaskHistory(params.getId());
                int limit = Math.min(params.getHistoryLength(), history.size());
                List<Message> limitedHistory = history.subList(Math.max(0, history.size() - limit), history.size());
                Task taskWithHistory = new Task(task.getId(), task.getContextId(), task.getKind(), task.getStatus(), task.getArtifacts(), limitedHistory, task.getMetadata());
                return this.createSuccessResponse(request.getId(), taskWithHistory);
            }
            return this.createSuccessResponse(request.getId(), task);
        }
        catch (Exception e) {
            return this.createErrorResponse(request.getId(), ErrorCode.INVALID_REQUEST, "Invalid parameters");
        }
    }

    public JSONRPCResponse handleTaskCancel(JSONRPCRequest request) {
        try {
            TaskIDParams params = this.parseParams(request.getParams(), TaskIDParams.class);
            Task task = this.taskStore.get(params.getId());
            if (task == null) {
                return this.createErrorResponse(request.getId(), ErrorCode.TASK_NOT_FOUND, "Task not found");
            }
            if (task.getStatus().getState() == TaskState.COMPLETED || task.getStatus().getState() == TaskState.CANCELED || task.getStatus().getState() == TaskState.FAILED) {
                return this.createErrorResponse(request.getId(), ErrorCode.TASK_NOT_CANCELABLE, "Task cannot be canceled");
            }
            TaskStatus canceledStatus = new TaskStatus(TaskState.CANCELED, null, Instant.now().toString());
            Task canceledTask = new Task(task.getId(), task.getContextId(), task.getKind(), canceledStatus, task.getArtifacts(), task.getHistory(), task.getMetadata());
            this.taskStore.put(params.getId(), canceledTask);
            return this.createSuccessResponse(request.getId(), canceledTask);
        }
        catch (Exception e) {
            return this.createErrorResponse(request.getId(), ErrorCode.INVALID_REQUEST, "Invalid parameters");
        }
    }

    public AgentCard getAgentCard() {
        return this.agentCard;
    }

    public List<Message> getTaskHistory(String taskId) {
        return this.taskHistory.getOrDefault(taskId, new ArrayList());
    }

    private <T> T parseParams(Object params, Class<T> clazz) throws Exception {
        return (T)this.objectMapper.convertValue(params, clazz);
    }

    private JSONRPCResponse createSuccessResponse(Object id, Object result) {
        return new JSONRPCResponse(id, "2.0", result, null);
    }

    private JSONRPCResponse createErrorResponse(Object id, ErrorCode code, String message) {
        JSONRPCError error = new JSONRPCError(code.getValue(), message, null);
        return new JSONRPCResponse(id, "2.0", null, error);
    }
}

