/*
 * Decompiled with CFR 0.152.
 */
package io.a2a_preview.server;

import io.a2a_preview.model.A2AError;
import io.a2a_preview.model.AgentCard;
import io.a2a_preview.model.ErrorCode;
import io.a2a_preview.model.JSONRPCError;
import io.a2a_preview.model.JSONRPCRequest;
import io.a2a_preview.model.JSONRPCResponse;
import io.a2a_preview.model.SendTaskStreamingResponse;
import io.a2a_preview.model.Task;
import io.a2a_preview.model.TaskSendParams;
import io.a2a_preview.model.TaskState;
import io.a2a_preview.model.TaskStatus;
import io.a2a_preview.model.TaskStatusUpdateEvent;
import io.a2a_preview.server.A2AServer;
import java.io.IOException;
import java.time.Instant;
import org.noear.snack.ONode;
import org.noear.solon.annotation.Body;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Post;
import org.noear.solon.web.sse.SseEmitter;
import org.noear.solon.web.sse.SseEvent;

public class A2AServerEndpoint {
    private final A2AServer server;

    public A2AServerEndpoint(A2AServer server) {
        this.server = server;
    }

    @Post
    @Mapping(value="a2a")
    public JSONRPCResponse handleJsonRpcRequest(@Body JSONRPCRequest request) {
        System.err.println("handleJsonRpcRequest(), request = " + request);
        if (!"2.0".equals(request.getJsonrpc())) {
            JSONRPCError error = new JSONRPCError(ErrorCode.INVALID_REQUEST.getValue(), "Invalid JSON-RPC version", null);
            JSONRPCResponse response = new JSONRPCResponse(request.getId(), "2.0", null, error);
            return response;
        }
        if ("message/send".equals(request.getMethod())) {
            return this.server.handleTaskSend(request);
        }
        if ("tasks/get".equals(request.getMethod())) {
            return this.server.handleTaskGet(request);
        }
        if ("tasks/cancel".equals(request.getMethod())) {
            return this.server.handleTaskCancel(request);
        }
        return new JSONRPCResponse(request.getId(), "2.0", null, new JSONRPCError(ErrorCode.METHOD_NOT_FOUND.getValue(), "Method not found", null));
    }

    @Post
    @Mapping(value="a2a/streaming")
    public SseEmitter handleStreamingTask(@Body JSONRPCRequest request) {
        System.err.println("handleStreamingTask(), request = " + request);
        return new SseEmitter(-1L).onInited(emitter -> {
            try {
                if (!"message/send".equals(request.getMethod())) {
                    this.sendErrorEvent((SseEmitter)emitter, request.getId(), ErrorCode.METHOD_NOT_FOUND, "Method not found");
                    return;
                }
                TaskSendParams params = (TaskSendParams)ONode.load((Object)request.getParams()).toObject(TaskSendParams.class);
                TaskStatus initialStatus = new TaskStatus(TaskState.WORKING, null, Instant.now().toString());
                TaskStatusUpdateEvent initialEvent = new TaskStatusUpdateEvent(params.getId(), initialStatus, false, null);
                SendTaskStreamingResponse initialResponse = new SendTaskStreamingResponse(request.getId(), "2.0", initialEvent, null);
                emitter.send(new SseEvent().name("task-complete").data((Object)ONode.stringify((Object)initialResponse)));
                JSONRPCResponse taskResponse = this.server.handleTaskSend(request);
                if (taskResponse.getError() != null) {
                    this.sendErrorEvent((SseEmitter)emitter, request.getId(), ErrorCode.INTERNAL_ERROR, taskResponse.getError().getMessage());
                    return;
                }
                Task completedTask = (Task)taskResponse.getResult();
                TaskStatusUpdateEvent finalEvent = new TaskStatusUpdateEvent(completedTask.getId(), completedTask.getStatus(), true, null);
                SendTaskStreamingResponse finalResponse = new SendTaskStreamingResponse(request.getId(), "2.0", finalEvent, null);
                emitter.send(new SseEvent().name("task-update").data((Object)ONode.stringify((Object)finalResponse)));
                emitter.complete();
            }
            catch (Exception e) {
                this.sendErrorEvent((SseEmitter)emitter, request.getId(), ErrorCode.INTERNAL_ERROR, e.getMessage());
            }
        });
    }

    @Mapping(value="/.well-known/agent.json")
    public AgentCard getAgentCard() {
        System.err.println("getAgentCard()");
        AgentCard agentCard = this.server.getAgentCard();
        return agentCard;
    }

    private void sendErrorEvent(SseEmitter emitter, Object requestId, ErrorCode code, String message) {
        try {
            A2AError error = new A2AError(code, message, null);
            SendTaskStreamingResponse errorResponse = new SendTaskStreamingResponse(requestId, "2.0", null, error);
            emitter.send(new SseEvent().name("error").data((Object)ONode.stringify((Object)errorResponse)));
            emitter.error((Throwable)new RuntimeException(message));
        }
        catch (IOException e) {
            emitter.error((Throwable)e);
        }
    }
}

