/*
 * Decompiled with CFR 0.152.
 */
package io.a2a_preview.client;

import io.a2a_preview.client.StreamingEventListener;
import io.a2a_preview.model.A2AError;
import io.a2a_preview.model.AgentCard;
import io.a2a_preview.model.JSONRPCRequest;
import io.a2a_preview.model.JSONRPCResponse;
import io.a2a_preview.model.SendTaskStreamingResponse;
import io.a2a_preview.model.TaskIDParams;
import io.a2a_preview.model.TaskQueryParams;
import io.a2a_preview.model.TaskSendParams;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.noear.snack.ONode;
import org.noear.solon.net.http.HttpResponse;
import org.noear.solon.net.http.HttpUtils;

public class A2AClient {
    private final String baseUrl;

    public A2AClient(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
    }

    public JSONRPCResponse sendTask(TaskSendParams params) throws Exception {
        JSONRPCRequest request = new JSONRPCRequest(this.generateRequestId(), "2.0", "message/send", params);
        return this.doRequest(request);
    }

    public JSONRPCResponse getTask(TaskQueryParams params) throws Exception {
        JSONRPCRequest request = new JSONRPCRequest(this.generateRequestId(), "2.0", "tasks/get", params);
        return this.doRequest(request);
    }

    public JSONRPCResponse cancelTask(TaskIDParams params) throws Exception {
        JSONRPCRequest request = new JSONRPCRequest(this.generateRequestId(), "2.0", "tasks/cancel", params);
        return this.doRequest(request);
    }

    public CompletableFuture<Void> sendTaskStreaming(TaskSendParams params, StreamingEventListener listener) {
        return CompletableFuture.runAsync(() -> {
            try {
                JSONRPCRequest request = new JSONRPCRequest(this.generateRequestId(), "2.0", "message/send", params);
                String requestBody = ONode.stringify((Object)request);
                HttpUtils req = HttpUtils.http((String)(this.baseUrl + "/a2a/stream")).contentType("application/json").charset("utf-8").header("Accept", "text/event-stream").bodyOfJson(requestBody);
                try (HttpResponse response = req.exec("POST");){
                    String line;
                    if (response.code() != 200) {
                        listener.onError(new Exception("HTTP " + response.code() + ": " + response.body()));
                        return;
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(response.body()));
                    while ((line = reader.readLine()) != null) {
                        SendTaskStreamingResponse streamingResponse;
                        block31: {
                            if (line.trim().isEmpty()) continue;
                            try {
                                streamingResponse = (SendTaskStreamingResponse)ONode.deserialize((String)line, SendTaskStreamingResponse.class);
                                if (streamingResponse.getError() == null) break block31;
                                A2AError error = streamingResponse.getError();
                                Integer errorCode = error.getCode() != null ? Integer.valueOf(error.getCode().getValue()) : null;
                                listener.onError(new Exception(error.getMessage()));
                                return;
                            }
                            catch (Exception e) {
                                listener.onError(new Exception("Failed to parse streaming response", e));
                                if (response != null) {
                                    if (var7_8 != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable) {
                                            var7_8.addSuppressed(throwable);
                                        }
                                    } else {
                                        response.close();
                                    }
                                }
                                return;
                            }
                        }
                        if (streamingResponse.getResult() == null) continue;
                        listener.onEvent(streamingResponse.getResult());
                    }
                    listener.onComplete();
                }
            }
            catch (Exception e) {
                listener.onError(new Exception("Streaming request failed", e));
            }
        });
    }

    public AgentCard getAgentCard() {
        return (AgentCard)HttpUtils.http((String)(this.baseUrl + "/.well-known/agent.json")).header("Accept", "application/json").getAs(AgentCard.class);
    }

    private JSONRPCResponse doRequest(JSONRPCRequest request) throws Exception {
        try {
            JSONRPCResponse response = (JSONRPCResponse)HttpUtils.http((String)(this.baseUrl + "/a2a")).header("Content-Type", "application/json").bodyOfBean((Object)request).postAs(JSONRPCResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new Exception("Request failed", e);
        }
    }

    private String generateRequestId() {
        return UUID.randomUUID().toString();
    }
}

